/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.cmd.swarm;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.model.ContainerSpec;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.NetworkAttachmentConfig;
import com.github.dockerjava.api.model.Service;
import com.github.dockerjava.api.model.ServiceModeConfig;
import com.github.dockerjava.api.model.ServiceReplicatedModeOptions;
import com.github.dockerjava.api.model.ServiceSpec;
import com.github.dockerjava.api.model.TaskSpec;
import com.github.dockerjava.cmd.swarm.SwarmCmdIT;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class UpdateSwarmServiceIT
extends SwarmCmdIT {
    @Test
    public void testUpdateServiceReplicate() throws Exception {
        DockerClient dockerClient = this.startSwarm();
        String networkId = ((CreateNetworkResponse)dockerClient.createNetworkCmd().withName("networkname").withDriver("overlay").withIpam(new Network.Ipam().withDriver("default")).exec()).getId();
        TaskSpec taskSpec = new TaskSpec().withContainerSpec(new ContainerSpec().withImage("busybox").withArgs(Arrays.asList("sleep", "3600")));
        ServiceSpec serviceSpec = new ServiceSpec().withMode(new ServiceModeConfig().withReplicated(new ServiceReplicatedModeOptions().withReplicas(1))).withTaskTemplate(taskSpec).withNetworks((List)Lists.newArrayList((Object[])new NetworkAttachmentConfig[]{new NetworkAttachmentConfig().withTarget(networkId)})).withName("worker");
        String serviceId = dockerClient.createServiceCmd(serviceSpec).exec().getId();
        Awaitility.await().untilAsserted(() -> {
            List services = (List)dockerClient.listServicesCmd().withIdFilter(Arrays.asList(serviceId)).exec();
            MatcherAssert.assertThat((Object)services.size(), (Matcher)Matchers.is((Object)1));
            Service service = (Service)services.get(0);
            ServiceSpec updateServiceSpec = service.getSpec().withMode(new ServiceModeConfig().withReplicated(new ServiceReplicatedModeOptions().withReplicas(2)));
            dockerClient.updateServiceCmd(service.getId(), updateServiceSpec).withVersion(service.getVersion().getIndex()).exec();
            Service updateService = (Service)((List)dockerClient.listServicesCmd().withIdFilter(Arrays.asList(serviceId)).exec()).get(0);
            MatcherAssert.assertThat((Object)updateService.getSpec().getMode().getReplicated().getReplicas(), (Matcher)Matchers.is((Object)2L));
        });
    }
}

