/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.core.DockerConfigFile;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DockerConfigFileTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();
    private final File FILESROOT = new File(DockerConfigFileTest.class.getResource("/testAuthConfigFile").getFile());

    @Test
    public void emptyFile() throws IOException {
        this.expectedEx.expect(IOException.class);
        this.expectedEx.expectMessage("The Auth Config file is empty");
        this.runTest("emptyFile");
    }

    @Test
    public void tooSmallFile() throws IOException {
        this.expectedEx.expect(IOException.class);
        this.expectedEx.expectMessage("The Auth Config file is empty");
        this.runTest("tooSmallFile");
    }

    @Test
    public void invalidJsonInvalidAuth() throws IOException {
        this.expectedEx.expect(IOException.class);
        this.expectedEx.expectMessage("Invalid auth configuration file");
        this.runTest("invalidJsonInvalidAuth");
    }

    @Test
    public void invalidLegacyAuthLine() throws IOException {
        this.expectedEx.expect(IOException.class);
        this.expectedEx.expectMessage("Invalid Auth config file");
        this.runTest("invalidLegacyAuthLine");
    }

    @Test
    public void invalidLegacyInvalidAuth() throws IOException {
        this.expectedEx.expect(IOException.class);
        this.expectedEx.expectMessage("Invalid auth configuration file");
        this.runTest("invalidLegacyInvalidAuth");
    }

    @Test
    public void invalidLegacyEmailLine() throws IOException {
        this.expectedEx.expect(IOException.class);
        this.expectedEx.expectMessage("Invalid Auth config file");
        this.runTest("invalidLegacyEmailLine");
    }

    @Test
    public void validLegacyJson() throws IOException {
        AuthConfig authConfig1 = new AuthConfig().withEmail("foo@example.com").withUsername("foo").withPassword("bar").withRegistryAddress("quay.io");
        AuthConfig authConfig2 = new AuthConfig().withEmail("moo@example.com").withUsername("foo1").withPassword("bar1").withRegistryAddress("https://index.docker.io/v1/");
        DockerConfigFile expected = new DockerConfigFile();
        expected.addAuthConfig(authConfig1);
        expected.addAuthConfig(authConfig2);
        MatcherAssert.assertThat((Object)this.runTest("validLegacyJson"), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void validJsonWithUnknown() throws IOException {
        AuthConfig authConfig1 = new AuthConfig().withRegistryAddress("192.168.99.100:32768");
        AuthConfig authConfig2 = new AuthConfig().withEmail("foo@example.com").withUsername("foo").withPassword("bar").withRegistryAddress("https://index.docker.io/v1/");
        DockerConfigFile expected = new DockerConfigFile();
        expected.addAuthConfig(authConfig1);
        expected.addAuthConfig(authConfig2);
        DockerConfigFile actual = this.runTest("validJsonWithUnknown");
        MatcherAssert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void validJsonWithOnlyUnknown() throws IOException {
        DockerConfigFile expected = new DockerConfigFile();
        DockerConfigFile actual = this.runTest("validJsonWithOnlyUnknown");
        MatcherAssert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void validLegacy() throws IOException {
        AuthConfig authConfig = new AuthConfig().withEmail("foo@example.com").withUsername("foo").withPassword("bar").withRegistryAddress("https://index.docker.io/v1/");
        DockerConfigFile expected = new DockerConfigFile();
        expected.addAuthConfig(authConfig);
        MatcherAssert.assertThat((Object)this.runTest("validLegacy"), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void validDockerConfig() throws IOException {
        AuthConfig authConfig1 = new AuthConfig().withEmail("foo@example.com").withUsername("foo").withPassword("bar").withRegistryAddress("quay.io");
        AuthConfig authConfig2 = new AuthConfig().withEmail("moo@example.com").withUsername("foo1").withPassword("bar1").withRegistryAddress("https://index.docker.io/v1/");
        DockerConfigFile expected = new DockerConfigFile();
        expected.addAuthConfig(authConfig1);
        expected.addAuthConfig(authConfig2);
        MatcherAssert.assertThat((Object)this.runTest("validDockerConfig"), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void nonExistent() throws IOException {
        DockerConfigFile expected = new DockerConfigFile();
        MatcherAssert.assertThat((Object)this.runTest("idontexist"), (Matcher)Is.is((Object)expected));
    }

    private DockerConfigFile runTest(String testFileName) throws IOException {
        return DockerConfigFile.loadConfig((ObjectMapper)JSONTestHelper.getMapper(), (String)new File(this.FILESROOT, testFileName).getAbsolutePath());
    }
}

