/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerClientDelegate;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.CreateVolumeCmd;
import com.github.dockerjava.api.command.CreateVolumeResponse;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.core.DockerCmdExecFactoryDelegate;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.utils.LogContainerTestCallback;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerRule
extends ExternalResource {
    public static final Logger LOG = LoggerFactory.getLogger(DockerRule.class);
    public static final String DEFAULT_IMAGE = "busybox:latest";
    private DockerClient dockerClient;
    private final Set<String> createdContainerIds = new HashSet<String>();
    private final Set<String> createdNetworkIds = new HashSet<String>();
    private final Set<String> createdVolumeNames = new HashSet<String>();
    private final DefaultDockerClientConfig config = DockerRule.config();

    public DockerClient newClient() {
        final DockerClientImpl dockerClient = CmdIT.createDockerClient((DockerClientConfig)this.config);
        dockerClient.withDockerCmdExecFactory((DockerCmdExecFactory)new DockerCmdExecFactoryDelegate(dockerClient.dockerCmdExecFactory){

            public CreateContainerCmd.Exec createCreateContainerCmdExec() {
                CreateContainerCmd.Exec exec = super.createCreateContainerCmdExec();
                return command -> {
                    CreateContainerResponse response = (CreateContainerResponse)exec.exec(command);
                    DockerRule.this.createdContainerIds.add(response.getId());
                    return response;
                };
            }

            public CreateNetworkCmd.Exec createCreateNetworkCmdExec() {
                CreateNetworkCmd.Exec exec = super.createCreateNetworkCmdExec();
                return command -> {
                    CreateNetworkResponse response = (CreateNetworkResponse)exec.exec(command);
                    DockerRule.this.createdNetworkIds.add(response.getId());
                    return response;
                };
            }

            public CreateVolumeCmd.Exec createCreateVolumeCmdExec() {
                CreateVolumeCmd.Exec exec = super.createCreateVolumeCmdExec();
                return command -> {
                    CreateVolumeResponse response = (CreateVolumeResponse)exec.exec(command);
                    DockerRule.this.createdVolumeNames.add(response.getName());
                    return response;
                };
            }
        });
        return new DockerClientDelegate(){

            protected DockerClient getDockerClient() {
                return dockerClient;
            }
        };
    }

    public DefaultDockerClientConfig getConfig() {
        return this.config;
    }

    public DockerClient getClient() {
        if (this.dockerClient != null) {
            return this.dockerClient;
        }
        this.dockerClient = this.newClient();
        return this.dockerClient;
    }

    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        LOG.debug("Connecting to Docker server");
        try {
            this.getClient().inspectImageCmd(DEFAULT_IMAGE).exec();
        }
        catch (NotFoundException e) {
            LOG.info("Pulling image 'busybox'");
            this.getClient().pullImageCmd("busybox").withTag("latest").start().awaitCompletion();
        }
    }

    protected void after() {
        this.createdContainerIds.parallelStream().forEach(containerId -> {
            try {
                this.dockerClient.removeContainerCmd(containerId).withForce(Boolean.valueOf(true)).withRemoveVolumes(Boolean.valueOf(true)).exec();
            }
            catch (ConflictException | NotFoundException throwable) {
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.debug("Failed to remove container {}", containerId, (Object)e);
            }
        });
        this.createdNetworkIds.parallelStream().forEach(networkId -> {
            try {
                this.dockerClient.removeNetworkCmd(networkId).exec();
            }
            catch (ConflictException | NotFoundException throwable) {
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.debug("Failed to remove network {}", networkId, (Object)e);
            }
        });
        this.createdVolumeNames.parallelStream().forEach(volumeName -> {
            try {
                this.dockerClient.removeVolumeCmd(volumeName).exec();
            }
            catch (ConflictException | NotFoundException throwable) {
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.debug("Failed to remove volume {}", volumeName, (Object)e);
            }
        });
        try {
            this.dockerClient.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to close the DockerClient", (Throwable)e);
        }
    }

    private static DefaultDockerClientConfig config() {
        return DockerRule.config(null);
    }

    public static DefaultDockerClientConfig config(String password) {
        DefaultDockerClientConfig.Builder builder = DefaultDockerClientConfig.createDefaultConfigBuilder().withApiVersion(RemoteApiVersion.VERSION_1_30).withRegistryUrl("https://index.docker.io/v1/");
        if (password != null) {
            builder = builder.withRegistryPassword(password);
        }
        return builder.build();
    }

    public String buildImage(File baseDir) throws Exception {
        return this.getClient().buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).start().awaitImageId();
    }

    public String containerLog(String containerId) throws Exception {
        return ((ResultCallback.Adapter)((LogContainerTestCallback)this.getClient().logContainerCmd(containerId).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)new LogContainerTestCallback())).awaitCompletion()).toString();
    }

    public void ensureContainerRemoved(String container1Name) {
        try {
            this.getClient().removeContainerCmd(container1Name).withForce(Boolean.valueOf(true)).withRemoveVolumes(Boolean.valueOf(true)).exec();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

