/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.core.GoLangFileMatch;
import com.github.dockerjava.core.exception.GoLangFileMatchException;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GoLangFileMatchTest {
    @Parameterized.Parameter
    public MatchTestCase testCase;

    @Parameterized.Parameters
    public static Object[][] getTestData() {
        return new Object[][]{{new MatchTestCase("", "abc", false, false)}, {new MatchTestCase("abc", "abc", true, false)}, {new MatchTestCase("*", "abc", true, false)}, {new MatchTestCase("*c", "abc", true, false)}, {new MatchTestCase("a*", "a", true, false)}, {new MatchTestCase("a*", "abc", true, false)}, {new MatchTestCase("a*", "ab/c", true, false)}, {new MatchTestCase("a*/b", "abc/b", true, false)}, {new MatchTestCase("a*/b", "a/c/b", false, false)}, {new MatchTestCase("a*b*c*d*e*/f", "axbxcxdxe/f", true, false)}, {new MatchTestCase("a*b*c*d*e*/f", "axbxcxdxexxx/f", true, false)}, {new MatchTestCase("a*b*c*d*e*/f", "axbxcxdxe/xxx/f", false, false)}, {new MatchTestCase("a*b*c*d*e*/f", "axbxcxdxexxx/fff", false, false)}, {new MatchTestCase("a*b?c*x", "abxbbxdbxebxczzx", true, false)}, {new MatchTestCase("a*b?c*x", "abxbbxdbxebxczzy", false, false)}, {new MatchTestCase("ab[c]", "abc", true, false)}, {new MatchTestCase("ab[b-d]", "abc", true, false)}, {new MatchTestCase("ab[e-g]", "abc", false, false)}, {new MatchTestCase("ab[^c]", "abc", false, false)}, {new MatchTestCase("ab[^b-d]", "abc", false, false)}, {new MatchTestCase("ab[^e-g]", "abc", true, false)}, {new MatchTestCase("a\\*b", "a*b", true, false)}, {new MatchTestCase("a\\*b", "ab", false, false)}, {new MatchTestCase("a?b", "a\u263ab", true, false)}, {new MatchTestCase("a[^a]b", "a\u263ab", true, false)}, {new MatchTestCase("a???b", "a\u263ab", false, false)}, {new MatchTestCase("a[^a][^a][^a]b", "a\u263ab", false, false)}, {new MatchTestCase("[a-\u03b6]*", "\u03b1", true, false)}, {new MatchTestCase("*[a-\u03b6]", "A", false, false)}, {new MatchTestCase("a?b", "a/b", false, false)}, {new MatchTestCase("a*b", "a/b", false, false)}, {new MatchTestCase("[\\]a]", "]", true, false)}, {new MatchTestCase("[\\-]", "-", true, false)}, {new MatchTestCase("[x\\-]", "x", true, false)}, {new MatchTestCase("[x\\-]", "-", true, false)}, {new MatchTestCase("[x\\-]", "z", false, false)}, {new MatchTestCase("[\\-x]", "x", true, false)}, {new MatchTestCase("[\\-x]", "-", true, false)}, {new MatchTestCase("[\\-x]", "a", false, false)}, {new MatchTestCase("[]a]", "]", false, true)}, {new MatchTestCase("[-]", "-", false, true)}, {new MatchTestCase("[x-]", "x", false, true)}, {new MatchTestCase("[x-]", "-", false, true)}, {new MatchTestCase("[x-]", "z", false, true)}, {new MatchTestCase("[-x]", "x", false, true)}, {new MatchTestCase("[-x]", "-", false, true)}, {new MatchTestCase("[-x]", "a", false, true)}, {new MatchTestCase("\\", "a", false, true)}, {new MatchTestCase("[a-b-c]", "a", false, true)}, {new MatchTestCase("[", "a", false, true)}, {new MatchTestCase("[^", "a", false, true)}, {new MatchTestCase("[^bc", "a", false, true)}, {new MatchTestCase("a[", "a", false, true)}, {new MatchTestCase("a[", "ab", false, true)}, {new MatchTestCase("*x", "xxx", true, false)}, {new MatchTestCase("a", "a/b/c", true, false)}, {new MatchTestCase("*/b", "a/b/c", true, false)}, {new MatchTestCase("**/b/*/d", "a/b/c/d", true, false)}, {new MatchTestCase("**/c", "a/b/c", true, false)}};
    }

    @Test
    public void testMatch() throws IOException {
        block5: {
            String pattern = this.testCase.pattern;
            String s = this.testCase.s;
            if (GoLangFileMatch.IS_WINDOWS) {
                if (pattern.indexOf(92) >= 0) {
                    return;
                }
                pattern = FilenameUtils.normalize((String)pattern);
                s = FilenameUtils.normalize((String)s);
            }
            try {
                Boolean matched = GoLangFileMatch.match((String)pattern, (String)s);
                if (this.testCase.expectException.booleanValue()) {
                    Assert.fail((String)"Expected GoFileMatchException");
                }
                Assert.assertEquals((String)this.testCase.toString(), (Object)this.testCase.matches, (Object)matched);
            }
            catch (GoLangFileMatchException e) {
                if (this.testCase.expectException.booleanValue()) break block5;
                throw e;
            }
        }
    }

    private static final class MatchTestCase {
        private final String pattern;
        private final String s;
        private final Boolean matches;
        private final Boolean expectException;

        public MatchTestCase(String pattern, String s, Boolean matches, Boolean expectException) {
            this.pattern = pattern;
            this.s = s;
            this.matches = matches;
            this.expectException = expectException;
        }

        public String toString() {
            return "MatchTestCase [pattern=" + this.pattern + ", s=" + this.s + ", matches=" + this.matches + ", expectException=" + this.expectException + "]";
        }
    }
}

