/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.exception.InvalidRepositoryNameException;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class NameParserTest {
    @Test
    public void testValidateRepoName() throws Exception {
        NameParser.validateRepoName((String)"repository");
        NameParser.validateRepoName((String)"namespace/repository");
        NameParser.validateRepoName((String)"namespace-with-dashes/repository");
        NameParser.validateRepoName((String)"namespace/repository-with-dashes");
        NameParser.validateRepoName((String)"namespace.with.dots/repository");
        NameParser.validateRepoName((String)"namespace/repository.with.dots");
        NameParser.validateRepoName((String)"namespace_with_underscores/repository");
        NameParser.validateRepoName((String)"namespace/repository_with_underscores");
    }

    @Test(expected=InvalidRepositoryNameException.class)
    public void testValidateRepoNameEmpty() throws Exception {
        NameParser.validateRepoName((String)"");
    }

    @Test(expected=InvalidRepositoryNameException.class)
    public void testValidateRepoNameExceedsMaxLength() throws Exception {
        NameParser.validateRepoName((String)StringUtils.repeat((String)"repository", (int)255));
    }

    @Test(expected=InvalidRepositoryNameException.class)
    public void testValidateRepoNameEndWithDash() throws Exception {
        NameParser.validateRepoName((String)"repository-");
    }

    @Test(expected=InvalidRepositoryNameException.class)
    public void testValidateRepoNameStartWithDash() throws Exception {
        NameParser.validateRepoName((String)"-repository");
    }

    @Test(expected=InvalidRepositoryNameException.class)
    public void testValidateRepoNameEndWithDot() throws Exception {
        NameParser.validateRepoName((String)"repository.");
    }

    @Test(expected=InvalidRepositoryNameException.class)
    public void testValidateRepoNameStartWithDot() throws Exception {
        NameParser.validateRepoName((String)".repository");
    }

    @Test(expected=InvalidRepositoryNameException.class)
    public void testValidateRepoNameEndWithUnderscore() throws Exception {
        NameParser.validateRepoName((String)"repository_");
    }

    @Test(expected=InvalidRepositoryNameException.class)
    public void testValidateRepoNameStartWithUnderscore() throws Exception {
        NameParser.validateRepoName((String)"_repository");
    }

    @Test(expected=InvalidRepositoryNameException.class)
    public void testValidateRepoNameWithColon() throws Exception {
        NameParser.validateRepoName((String)"repository:with:colon");
    }

    @Test
    public void testResolveSimpleRepositoryName() throws Exception {
        NameParser.HostnameReposName resolved = NameParser.resolveRepositoryName((String)"repository");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.HostnameReposName("https://index.docker.io/v1/", "repository"));
    }

    @Test
    public void testResolveRepositoryNameWithNamespace() throws Exception {
        NameParser.HostnameReposName resolved = NameParser.resolveRepositoryName((String)"namespace/repository");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.HostnameReposName("https://index.docker.io/v1/", "namespace/repository"));
    }

    @Test
    public void testResolveRepositoryNameWithNamespaceAndSHA256() throws Exception {
        NameParser.HostnameReposName resolved = NameParser.resolveRepositoryName((String)"namespace/repository@sha256:sha256");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.HostnameReposName("https://index.docker.io/v1/", "namespace/repository@sha256:sha256"));
    }

    @Test
    public void testResolveRepositoryNameWithNamespaceAndHostname() throws Exception {
        NameParser.HostnameReposName resolved = NameParser.resolveRepositoryName((String)"localhost:5000/namespace/repository");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.HostnameReposName("localhost:5000", "namespace/repository"));
    }

    @Test
    public void testResolveRepositoryNameWithNamespaceAndHostnameAndSHA256() throws Exception {
        NameParser.HostnameReposName resolved = NameParser.resolveRepositoryName((String)"localhost:5000/namespace/repository@sha256:sha256");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.HostnameReposName("localhost:5000", "namespace/repository"));
    }

    @Test(expected=InvalidRepositoryNameException.class)
    public void testResolveRepositoryNameWithIndex() throws Exception {
        NameParser.resolveRepositoryName((String)"index.docker.io/repository");
    }

    @Test
    public void testResolveReposTagWithoutTagSimple() throws Exception {
        NameParser.ReposTag resolved = NameParser.parseRepositoryTag((String)"repository");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.ReposTag("repository", ""));
        resolved = NameParser.parseRepositoryTag((String)"namespace/repository");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.ReposTag("namespace/repository", ""));
        resolved = NameParser.parseRepositoryTag((String)"localhost:5000/namespace/repository");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.ReposTag("localhost:5000/namespace/repository", ""));
    }

    @Test
    public void testResolveReposTagWithTag() throws Exception {
        NameParser.ReposTag resolved = NameParser.parseRepositoryTag((String)"repository:tag");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.ReposTag("repository", "tag"));
        resolved = NameParser.parseRepositoryTag((String)"namespace/repository:tag");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.ReposTag("namespace/repository", "tag"));
        resolved = NameParser.parseRepositoryTag((String)"localhost:5000/namespace/repository:tag");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.ReposTag("localhost:5000/namespace/repository", "tag"));
    }

    @Test
    public void testResolveReposTagWithSHA256() throws Exception {
        NameParser.ReposTag resolved = NameParser.parseRepositoryTag((String)"repository@sha256:sha256");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.ReposTag("repository@sha256:sha256", ""));
        resolved = NameParser.parseRepositoryTag((String)"namespace/repository@sha256:sha256");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.ReposTag("namespace/repository@sha256:sha256", ""));
        resolved = NameParser.parseRepositoryTag((String)"localhost:5000/namespace/repository@sha256:sha256");
        Assert.assertEquals((Object)resolved, (Object)new NameParser.ReposTag("localhost:5000/namespace/repository@sha256:sha256", ""));
    }
}

