/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Image;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerfileFixture
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerfileFixture.class);
    private final DockerClient client;
    private String directory;
    private String repository;
    private String containerId;

    public DockerfileFixture(DockerClient client, String directory) {
        this.client = client;
        this.directory = directory;
    }

    public void open() throws Exception {
        LOGGER.info("building {}", (Object)this.directory);
        this.client.buildImageCmd(new File("src/test/resources", this.directory)).withNoCache(Boolean.valueOf(true)).start().awaitImageId();
        Image lastCreatedImage = (Image)((List)this.client.listImagesCmd().exec()).get(0);
        this.repository = lastCreatedImage.getRepoTags()[0];
        LOGGER.info("created {} {}", (Object)lastCreatedImage.getId(), (Object)this.repository);
        this.containerId = this.client.createContainerCmd(lastCreatedImage.getId()).exec().getId();
        LOGGER.info("starting {}", (Object)this.containerId);
        this.client.startContainerCmd(this.containerId).exec();
    }

    @Override
    public void close() throws Exception {
        if (this.containerId != null) {
            LOGGER.info("removing container {}", (Object)this.containerId);
            try {
                this.client.removeContainerCmd(this.containerId).withForce(Boolean.valueOf(true)).exec();
            }
            catch (InternalServerErrorException | NotFoundException ignored) {
                LOGGER.info("ignoring {}", (Object)ignored.getMessage());
            }
            this.containerId = null;
        }
        if (this.repository != null) {
            LOGGER.info("removing repository {}", (Object)this.repository);
            try {
                this.client.removeImageCmd(this.repository).withForce(Boolean.valueOf(true)).exec();
            }
            catch (DockerException e) {
                LOGGER.info("ignoring {}", (Object)e.getMessage());
            }
            this.repository = null;
        }
    }

    public String getContainerId() {
        return this.containerId;
    }
}

