/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.command.DockerfileFixture;
import com.github.dockerjava.junit.DockerAssume;
import com.github.dockerjava.junit.category.Integration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Integration.class})
public class FrameReaderITest {
    private DockerClient dockerClient;
    private DockerfileFixture dockerfileFixture;

    @Before
    public void beforeTest() throws Exception {
        this.dockerClient = DockerClientBuilder.getInstance().build();
        this.dockerfileFixture = new DockerfileFixture(this.dockerClient, "frameReaderDockerfile");
        this.dockerfileFixture.open();
    }

    @After
    public void deleteDockerContainerImage() throws Exception {
        this.dockerfileFixture.close();
        this.dockerClient.close();
    }

    @Test
    public void canCloseFrameReaderAndReadExpectedLines() throws Exception {
        DockerAssume.assumeNotSwarm("", this.dockerClient);
        int exitCode = this.dockerClient.waitContainerCmd(this.dockerfileFixture.getContainerId()).start().awaitStatusCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        List<Frame> loggingFrames = this.getLoggingFrames();
        Frame outFrame = new Frame(StreamType.STDOUT, "to stdout\n".getBytes());
        Frame errFrame = new Frame(StreamType.STDERR, "to stderr\n".getBytes());
        MatcherAssert.assertThat(loggingFrames, (Matcher)Matchers.containsInAnyOrder((Object[])new Frame[]{outFrame, errFrame}));
        MatcherAssert.assertThat(loggingFrames, (Matcher)Matchers.hasSize((int)2));
    }

    private List<Frame> getLoggingFrames() throws Exception {
        FrameReaderITestCallback collectFramesCallback = new FrameReaderITestCallback();
        ((FrameReaderITestCallback)this.dockerClient.logContainerCmd(this.dockerfileFixture.getContainerId()).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withTailAll().exec((ResultCallback)collectFramesCallback)).awaitCompletion();
        return collectFramesCallback.frames;
    }

    @Test
    public void canLogInOneThreadAndExecuteCommandsInAnother() throws Exception {
        Thread thread = new Thread(() -> {
            try {
                Iterator<Frame> frames = this.getLoggingFrames().iterator();
                while (frames.hasNext()) {
                    frames.next();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        thread.start();
        try (DockerfileFixture busyboxDockerfile = new DockerfileFixture(this.dockerClient, "busyboxDockerfile");){
            busyboxDockerfile.open();
        }
        thread.join();
    }

    public static class FrameReaderITestCallback
    extends ResultCallback.Adapter<Frame> {
        public List<Frame> frames = new ArrayList<Frame>();

        public void onNext(Frame item) {
            this.frames.add(item);
            super.onNext((Object)item);
        }
    }
}

