/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.core.command.FrameReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class FrameReaderTest {
    public static final int HEADER_SIZE = 8;
    private final List<Integer> bytes = new ArrayList<Integer>();
    private final InputStream inputStream = new InputStream(){

        @Override
        public int read() throws IOException {
            return FrameReaderTest.this.bytes.isEmpty() ? -1 : (Integer)FrameReaderTest.this.bytes.remove(0);
        }
    };
    private final FrameReader frameReader = new FrameReader(this.inputStream);

    @Test
    public void endOfStreamReturnsNull() throws Exception {
        Assert.assertNull((Object)this.nextFrame(new int[0]));
    }

    @Test
    public void stdInBytesFrameReturnsFrame() throws Exception {
        Assert.assertEquals((Object)this.nextFrame(0, 0, 0, 0, 0, 0, 0, 0), (Object)new Frame(StreamType.STDIN, new byte[0]));
    }

    private Frame nextFrame(int ... bytes) throws IOException {
        this.setBytes(bytes);
        return this.frameReader.readFrame();
    }

    @Test
    public void stdOutBytesFrameReturnsFrame() throws Exception {
        Assert.assertEquals((Object)this.nextFrame(1, 0, 0, 0, 0, 0, 0, 0), (Object)new Frame(StreamType.STDOUT, new byte[0]));
    }

    @Test
    public void stdErrBytesFrameReturnsFrame() throws Exception {
        Assert.assertEquals((Object)this.nextFrame(2, 0, 0, 0, 0, 0, 0, 0), (Object)new Frame(StreamType.STDERR, new byte[0]));
    }

    private void setBytes(int ... bytes) {
        this.bytes.clear();
        for (int aByte : bytes) {
            this.bytes.add(aByte);
        }
    }
}

