/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.dockerfile;

import com.github.dockerjava.core.dockerfile.Dockerfile;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DockerfileAddMultipleFilesTest {
    private static final Function<File, String> TO_FILE_NAMES = File::getName;

    @Test
    public void ignoreAllBut() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/IgnoreAllBut");
        Dockerfile dockerfile = new Dockerfile(new File(baseDir, "Dockerfile"), baseDir);
        Dockerfile.ScannedResult result = dockerfile.parse();
        Collection filesToAdd = Collections2.transform((Collection)result.filesToAdd, TO_FILE_NAMES);
        MatcherAssert.assertThat((Object)filesToAdd, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Dockerfile", "foo.jar"}));
    }

    @Test
    public void nestedDirsPatterns() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/NestedDirsDockerignore");
        Dockerfile dockerfile = new Dockerfile(new File(baseDir, "Dockerfile"), baseDir);
        Dockerfile.ScannedResult result = dockerfile.parse();
        Collection filesToAdd = Collections2.transform((Collection)result.filesToAdd, TO_FILE_NAMES);
        MatcherAssert.assertThat((Object)filesToAdd, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Dockerfile", ".dockerignore", "README.md", "README-grand.md", "b.txt"}));
    }

    @Test
    public void effectiveIgnorePatterns() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/EffectiveDockerignorePatterns");
        Dockerfile dockerfile = new Dockerfile(new File(baseDir, "Dockerfile"), baseDir);
        Dockerfile.ScannedResult result = dockerfile.parse();
        Collection filesToAdd = Collections2.transform((Collection)result.filesToAdd, TO_FILE_NAMES);
        MatcherAssert.assertThat((Object)filesToAdd, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Dockerfile", ".dockerignore", "README.md"}));
    }

    @Test
    public void ineffectiveIgnorePattern() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/IneffectiveDockerignorePattern");
        Dockerfile dockerfile = new Dockerfile(new File(baseDir, "Dockerfile"), baseDir);
        Dockerfile.ScannedResult result = dockerfile.parse();
        Collection filesToAdd = Collections2.transform((Collection)result.filesToAdd, TO_FILE_NAMES);
        MatcherAssert.assertThat((Object)filesToAdd, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Dockerfile", ".dockerignore", "README.md", "README-secret.md"}));
    }

    @Test
    public void addFiles() throws IOException {
        File baseDir = this.fileFromBuildTestResource("ADD/files");
        new File(baseDir, "emptydir").mkdir();
        Dockerfile dockerfile = new Dockerfile(new File(baseDir, "Dockerfile"), baseDir);
        Dockerfile.ScannedResult result = dockerfile.parse();
        Collection filesToAdd = Collections2.transform((Collection)result.filesToAdd, TO_FILE_NAMES);
        MatcherAssert.assertThat((Object)filesToAdd, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"emptydir", "Dockerfile", "src1", "src2"}));
    }

    private File fileFromBuildTestResource(String resource) {
        return new File(Thread.currentThread().getContextClassLoader().getResource("buildTests/" + resource).getFile());
    }
}

