/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.dockerfile;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.core.dockerfile.DockerfileStatement;
import com.google.common.base.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class DockerfileStatementAddTest {

    public static final class Tests {
        @Test(expected=DockerClientException.class)
        public void shouldThrowExceptionIfDestNotSpecified() {
            DockerfileStatement.Add.create((String)"ADD src");
        }
    }

    @RunWith(value=Parameterized.class)
    public static final class ParamTests {
        @Parameterized.Parameter
        public String command;
        @Parameterized.Parameter(value=1)
        public Matcher matchesExpectation;
        @Parameterized.Parameter(value=2)
        public String expectedDest;

        @Parameterized.Parameters(name="{0} {1} {2}")
        public static Object[][] data() {
            return new Object[][]{{"ADD src dest", Matchers.contains((Object[])new String[]{"src"}), "dest"}, {"ADD \"src file\" \"dest\"", Matchers.contains((Object[])new String[]{"src file"}), "dest"}, {"ADD src\"file dest", Matchers.contains((Object[])new String[]{"src\"file"}), "dest"}, {"ADD src1 src2 dest", Matchers.containsInAnyOrder((Object[])new String[]{"src1", "src2"}), "dest"}, {"COPY src dest", Matchers.contains((Object[])new String[]{"src"}), "dest"}, {"COPY \"src file\" \"dest\"", Matchers.contains((Object[])new String[]{"src file"}), "dest"}, {"COPY src\"file dest", Matchers.contains((Object[])new String[]{"src\"file"}), "dest"}, {"COPY src1 src2 dest", Matchers.containsInAnyOrder((Object[])new String[]{"src1", "src2"}), "dest"}};
        }

        @Test
        public void testAddOrCopyPattern() {
            Optional optionalAdd = DockerfileStatement.Add.create((String)this.command);
            MatcherAssert.assertThat((Object)optionalAdd.isPresent(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((DockerfileStatement.Add)optionalAdd.get()).sources, (Matcher)this.matchesExpectation);
            MatcherAssert.assertThat((Object)((DockerfileStatement.Add)optionalAdd.get()).destination, (Matcher)Matchers.is((Object)this.expectedDest));
        }
    }
}

