/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.util;

import com.github.dockerjava.core.util.CompressArchiveUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CompressArchiveUtilTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void tarWithRegularFileAsInput() throws Exception {
        Path archiveSourceFile = this.tempFolder.getRoot().toPath().resolve("sourceFile");
        CompressArchiveUtilTest.createFileWithContent(archiveSourceFile);
        Path tarGzFile = this.tempFolder.newFile("archive.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceFile, (Path)tarGzFile, (boolean)true, (boolean)false);
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsNonEmptyFile(tarGzFile.toFile(), "sourceFile");
        tarGzFile = this.tempFolder.newFile("archiveChildrenOnly.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceFile, (Path)tarGzFile, (boolean)true, (boolean)false);
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsNonEmptyFile(tarGzFile.toFile(), "sourceFile");
    }

    @Test
    public void tarWithExecutableFileAsInput() throws Exception {
        Path archiveSourceFile = this.tempFolder.getRoot().toPath().resolve("executableFile.sh");
        CompressArchiveUtilTest.createFileWithContent(archiveSourceFile);
        archiveSourceFile.toFile().setExecutable(true);
        Path tarGzFile = this.tempFolder.newFile("archive.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceFile, (Path)tarGzFile, (boolean)true, (boolean)false);
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsExecutableFile(tarGzFile.toFile(), "executableFile.sh");
        tarGzFile = this.tempFolder.newFile("archiveChildrenOnly.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceFile, (Path)tarGzFile, (boolean)true, (boolean)false);
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsExecutableFile(tarGzFile.toFile(), "executableFile.sh");
    }

    @Test
    public void tarWithSymbolicLinkFileAsInput() throws IOException {
        Path archiveSourceFile = this.tempFolder.getRoot().toPath().resolve("symlinkFile");
        Path linkTargetFile = this.tempFolder.newFile("link-target").toPath();
        Files.createSymbolicLink(archiveSourceFile, linkTargetFile, new FileAttribute[0]);
        Path tarGzFile = this.tempFolder.newFile("archive.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceFile, (Path)tarGzFile, (boolean)true, (boolean)false);
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsSymlink(tarGzFile.toFile(), "symlinkFile", linkTargetFile.toString());
        tarGzFile = this.tempFolder.newFile("archiveChildrenOnly.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceFile, (Path)tarGzFile, (boolean)true, (boolean)false);
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsSymlink(tarGzFile.toFile(), "symlinkFile", linkTargetFile.toString());
    }

    @Test
    public void tarWithfolderAsInput() throws Exception {
        Path archiveSourceDir = this.tempFolder.newFolder("archive-source").toPath();
        CompressArchiveUtilTest.createFoldersAndSubFolderWithFiles(archiveSourceDir);
        Path tarGzFile = this.tempFolder.newFile("archive.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceDir, (Path)tarGzFile, (boolean)true, (boolean)false);
        Assert.assertEquals((long)7L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(tarGzFile.toFile(), "archive-source");
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(tarGzFile.toFile(), "folderA");
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(tarGzFile.toFile(), "folderB");
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(tarGzFile.toFile(), "subFolderB");
        CompressArchiveUtilTest.assertTarArchiveEntryIsNonEmptyFile(tarGzFile.toFile(), "fileA");
        CompressArchiveUtilTest.assertTarArchiveEntryIsNonEmptyFile(tarGzFile.toFile(), "fileB");
        CompressArchiveUtilTest.assertTarArchiveEntryIsNonEmptyFile(tarGzFile.toFile(), "subFileB");
        tarGzFile = this.tempFolder.newFile("archiveChildrenOnly.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceDir, (Path)tarGzFile, (boolean)true, (boolean)true);
        Assert.assertEquals((long)6L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(tarGzFile.toFile(), "folderA");
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(tarGzFile.toFile(), "folderB");
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(tarGzFile.toFile(), "subFolderB");
        CompressArchiveUtilTest.assertTarArchiveEntryIsNonEmptyFile(tarGzFile.toFile(), "fileA");
        CompressArchiveUtilTest.assertTarArchiveEntryIsNonEmptyFile(tarGzFile.toFile(), "fileB");
        CompressArchiveUtilTest.assertTarArchiveEntryIsNonEmptyFile(tarGzFile.toFile(), "subFileB");
    }

    @Test
    public void tarWithfolderAsInputAndNestedExecutableFile() throws Exception {
        Path archiveSourceDir = this.tempFolder.newFolder("archive-source").toPath();
        Path executableFile = archiveSourceDir.resolve("executableFile.sh");
        CompressArchiveUtilTest.createFileWithContent(executableFile);
        executableFile.toFile().setExecutable(true);
        Path tarGzFile = this.tempFolder.newFile("archive.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceDir, (Path)tarGzFile, (boolean)true, (boolean)false);
        Assert.assertEquals((long)2L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(tarGzFile.toFile(), "archive-source");
        CompressArchiveUtilTest.assertTarArchiveEntryIsExecutableFile(tarGzFile.toFile(), "executableFile.sh");
        tarGzFile = this.tempFolder.newFile("archiveChildrenOnly.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceDir, (Path)tarGzFile, (boolean)true, (boolean)true);
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsExecutableFile(tarGzFile.toFile(), "executableFile.sh");
    }

    @Test
    public void tarWithfolderAsInputAndNestedSymbolicLinkFile() throws Exception {
        Path archiveSourceDir = this.tempFolder.newFolder("archive-source").toPath();
        Path linkTargetFile = this.tempFolder.newFile("link-target").toPath();
        Path symlinkFile = archiveSourceDir.resolve("symlinkFile");
        Files.createSymbolicLink(symlinkFile, linkTargetFile, new FileAttribute[0]);
        Path tarGzFile = this.tempFolder.newFile("archive.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceDir, (Path)tarGzFile, (boolean)true, (boolean)false);
        Assert.assertEquals((long)2L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(tarGzFile.toFile(), "archive-source");
        CompressArchiveUtilTest.assertTarArchiveEntryIsSymlink(tarGzFile.toFile(), "symlinkFile", linkTargetFile.toString());
        tarGzFile = this.tempFolder.newFile("archiveChildrenOnly.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceDir, (Path)tarGzFile, (boolean)true, (boolean)true);
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsSymlink(tarGzFile.toFile(), "symlinkFile", linkTargetFile.toString());
    }

    @Test
    public void tarWithfolderAsInputAndNestedSymbolicLinkDir() throws Exception {
        Path archiveSourceDir = this.tempFolder.newFolder("archive-source").toPath();
        Path linkTargetDir = this.tempFolder.newFolder("link-target").toPath();
        Path symlinkFile = archiveSourceDir.resolve("symlinkFile");
        Files.createSymbolicLink(symlinkFile, linkTargetDir, new FileAttribute[0]);
        Path tarGzFile = this.tempFolder.newFile("archive.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceDir, (Path)tarGzFile, (boolean)true, (boolean)false);
        Assert.assertEquals((long)2L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(tarGzFile.toFile(), "archive-source");
        CompressArchiveUtilTest.assertTarArchiveEntryIsSymlink(tarGzFile.toFile(), "symlinkFile", linkTargetDir.toString());
        tarGzFile = this.tempFolder.newFile("archiveChildrenOnly.tar.gz").toPath();
        CompressArchiveUtil.tar((Path)archiveSourceDir, (Path)tarGzFile, (boolean)true, (boolean)true);
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(tarGzFile.toFile()));
        CompressArchiveUtilTest.assertTarArchiveEntryIsSymlink(tarGzFile.toFile(), "symlinkFile", linkTargetDir.toString());
    }

    @Test
    public void archiveTARFilesWithFolderAndFiles() throws Exception {
        File archive = CompressArchiveUtil.archiveTARFiles((File)this.tempFolder.getRoot(), CompressArchiveUtilTest.createFoldersAndSubFolderWithFiles(this.tempFolder.getRoot().toPath()), (String)"archive");
        Assert.assertEquals((long)6L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(archive));
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(archive, "folderA");
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(archive, "folderB");
        CompressArchiveUtilTest.assertTarArchiveEntryIsDirectory(archive, "subFolderB");
        CompressArchiveUtilTest.assertTarArchiveEntryIsNonEmptyFile(archive, "fileA");
        CompressArchiveUtilTest.assertTarArchiveEntryIsNonEmptyFile(archive, "fileB");
        CompressArchiveUtilTest.assertTarArchiveEntryIsNonEmptyFile(archive, "subFileB");
    }

    @Test
    public void archiveTARFilesWithExecutableFile() throws Exception {
        File executableFile = this.tempFolder.newFile("executableFile.sh");
        executableFile.setExecutable(true);
        File archive = CompressArchiveUtil.archiveTARFiles((File)this.tempFolder.getRoot(), Arrays.asList(executableFile), (String)"archive");
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(archive));
        CompressArchiveUtilTest.assertTarArchiveEntryIsExecutableFile(archive, "executableFile.sh");
    }

    @Test
    public void archiveTARFilesWithSymbolicLinkFile() throws Exception {
        Path linkTargetFile = this.tempFolder.newFile("link-target").toPath();
        Path symlinkFile = this.tempFolder.getRoot().toPath().resolve("symlinkFile");
        Files.createSymbolicLink(symlinkFile, linkTargetFile, new FileAttribute[0]);
        File archive = CompressArchiveUtil.archiveTARFiles((File)this.tempFolder.getRoot(), Arrays.asList(symlinkFile.toFile()), (String)"archive");
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(archive));
        CompressArchiveUtilTest.assertTarArchiveEntryIsSymlink(archive, "symlinkFile", linkTargetFile.toString());
    }

    @Test
    public void archiveTARFilesWithSymbolicLinkDir() throws Exception {
        Path linkTargetDir = this.tempFolder.newFolder("link-target").toPath();
        Path symlinkFile = this.tempFolder.getRoot().toPath().resolve("symlinkFile");
        Files.createSymbolicLink(symlinkFile, linkTargetDir, new FileAttribute[0]);
        File archive = CompressArchiveUtil.archiveTARFiles((File)this.tempFolder.getRoot(), Arrays.asList(symlinkFile.toFile()), (String)"archive");
        Assert.assertEquals((long)1L, (long)CompressArchiveUtilTest.getNumberOfEntryInArchive(archive));
        CompressArchiveUtilTest.assertTarArchiveEntryIsSymlink(archive, "symlinkFile", linkTargetDir.toString());
    }

    private static void assertTarArchiveEntryIsDirectory(File archive, String directoryName) throws IOException {
        TarArchiveEntry tarArchiveEntry = CompressArchiveUtilTest.getTarArchiveEntry(archive, directoryName);
        Assert.assertNotNull((Object)tarArchiveEntry);
        Assert.assertTrue((boolean)tarArchiveEntry.isDirectory());
    }

    private static void assertTarArchiveEntryIsNonEmptyFile(File archive, String fileName) throws IOException {
        TarArchiveEntry tarArchiveEntry = CompressArchiveUtilTest.getTarArchiveEntry(archive, fileName);
        Assert.assertNotNull((Object)tarArchiveEntry);
        Assert.assertTrue((boolean)tarArchiveEntry.isFile());
        Assert.assertTrue((tarArchiveEntry.getSize() > 0L ? 1 : 0) != 0);
    }

    private static void assertTarArchiveEntryIsExecutableFile(File archive, String fileName) throws IOException {
        TarArchiveEntry tarArchiveEntry = CompressArchiveUtilTest.getTarArchiveEntry(archive, fileName);
        Assert.assertNotNull((Object)tarArchiveEntry);
        Assert.assertTrue((boolean)tarArchiveEntry.isFile());
        Assert.assertEquals((String)"should be executable", (long)(tarArchiveEntry.getMode() & 0x1ED), (long)493L);
    }

    private static void assertTarArchiveEntryIsSymlink(File archive, String fileName, String expectedTarget) throws IOException {
        TarArchiveEntry tarArchiveEntry = CompressArchiveUtilTest.getTarArchiveEntry(archive, fileName);
        Assert.assertNotNull((Object)tarArchiveEntry);
        Assert.assertTrue((String)"should be a symbolic link", (boolean)tarArchiveEntry.isSymbolicLink());
        Assert.assertEquals((Object)expectedTarget, (Object)tarArchiveEntry.getLinkName());
    }

    private static List<File> createFoldersAndSubFolderWithFiles(Path destinationFolder) throws IOException {
        ArrayList<File> createdFiles = new ArrayList<File>();
        Path folderA = destinationFolder.resolve("folderA");
        createdFiles.add(Files.createDirectories(folderA, new FileAttribute[0]).toFile());
        createdFiles.add(CompressArchiveUtilTest.createFileWithContent(folderA.resolve("fileA")));
        Path folderB = destinationFolder.resolve("folderB");
        createdFiles.add(Files.createDirectories(folderB, new FileAttribute[0]).toFile());
        createdFiles.add(CompressArchiveUtilTest.createFileWithContent(folderB.resolve("fileB")));
        Path subFolderB = folderB.resolve("subFolderB");
        createdFiles.add(Files.createDirectories(subFolderB, new FileAttribute[0]).toFile());
        createdFiles.add(CompressArchiveUtilTest.createFileWithContent(folderA.resolve("subFileB")));
        return createdFiles;
    }

    private static File createFileWithContent(Path fileToCreate) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream("some content".getBytes());){
            Files.copy(in, fileToCreate, new CopyOption[0]);
        }
        return fileToCreate.toFile();
    }

    private static TarArchiveEntry getTarArchiveEntry(File tarArchive, String filename) throws IOException {
        try (TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(new FileInputStream(tarArchive))));){
            TarArchiveEntry entry;
            while ((entry = tarArchiveInputStream.getNextTarEntry()) != null) {
                if (!entry.getName().equals(filename) && !entry.getName().endsWith("/" + filename) && !entry.getName().equals(filename + "/") && !entry.getName().endsWith("/" + filename + "/")) continue;
                TarArchiveEntry tarArchiveEntry = entry;
                return tarArchiveEntry;
            }
        }
        return null;
    }

    private static int getNumberOfEntryInArchive(File tarArchive) throws IOException {
        int numberOfEntries = 0;
        try (TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(new FileInputStream(tarArchive))));){
            while (tarArchiveInputStream.getNextTarEntry() != null) {
                ++numberOfEntries;
            }
        }
        return numberOfEntries;
    }
}

