/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.util;

import com.github.dockerjava.core.util.FiltersBuilder;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class FiltersBuilderTest {
    @Test
    public void newFiltersShouldBeEquals() {
        Assert.assertEquals((Object)new FiltersBuilder(), (Object)new FiltersBuilder());
    }

    @Test
    public void newFiltersShouldHaveEqualHashcode() {
        Assert.assertEquals((long)new FiltersBuilder().hashCode(), (long)new FiltersBuilder().hashCode());
    }

    @Test
    public void filtersWithEqualContentShouldBeEquals() {
        Assert.assertEquals((Object)new FiltersBuilder().withContainers(new String[]{"foo"}), (Object)new FiltersBuilder().withContainers(new String[]{"foo"}));
        Assert.assertEquals((Object)new FiltersBuilder().withLabels(new String[]{"alpha=val"}), (Object)new FiltersBuilder().withLabels(new String[]{"alpha=val"}));
    }

    @Test
    public void filtersWithEqualContentShouldHaveEqualHashcode() {
        Assert.assertEquals((long)new FiltersBuilder().withContainers(new String[]{"foo"}).hashCode(), (long)new FiltersBuilder().withContainers(new String[]{"foo"}).hashCode());
        Assert.assertEquals((long)new FiltersBuilder().withLabels(new String[]{"alpha=val"}).hashCode(), (long)new FiltersBuilder().withLabels(new String[]{"alpha=val"}).hashCode());
    }

    @Test
    public void withLabelsMapShouldBeEqualsToVarargs() {
        HashMap map = Maps.newHashMap();
        map.put("alpha", "val");
        Assert.assertEquals((Object)new FiltersBuilder().withLabels(new String[]{"alpha=val"}), (Object)new FiltersBuilder().withLabels((Map)map));
        map = Maps.newHashMap();
        map.put("alpha", "val");
        map.put("beta", "val1");
        Assert.assertEquals((Object)new FiltersBuilder().withLabels(new String[]{"alpha=val", "beta=val1"}), (Object)new FiltersBuilder().withLabels((Map)map));
    }

    @Test
    public void filtersWithDifferentContentShouldntBeEquals() {
        Assert.assertNotEquals((Object)new FiltersBuilder().withContainers(new String[]{"foo"}), (Object)new FiltersBuilder().withContainers(new String[]{"bar"}));
    }

    @Test
    public void filtersWithDifferentContentShouldntHaveEqualHashcode() {
        Assert.assertNotEquals((long)new FiltersBuilder().withContainers(new String[]{"foo"}).hashCode(), (long)new FiltersBuilder().withContainers(new String[]{"bar"}).hashCode());
    }
}

