/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.junit;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.cmd.CmdIT;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerRule;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.rules.ExternalResource;

public class PrivateRegistryRule
extends ExternalResource {
    private final DockerClient dockerClient = CmdIT.createDockerClient((DockerClientConfig)DockerRule.config(null));
    private AuthConfig authConfig;
    private String containerId;

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public String createPrivateImage(String tagName) throws InterruptedException {
        String imgNameWithTag = this.createTestImage(tagName);
        this.dockerClient.pushImageCmd(imgNameWithTag).withAuthConfig(this.authConfig).start().awaitCompletion(30L, TimeUnit.SECONDS);
        this.dockerClient.removeImageCmd(imgNameWithTag).exec();
        Thread.sleep(5000L);
        return imgNameWithTag;
    }

    public String createTestImage(String tagName) {
        String imgName = this.authConfig.getRegistryAddress() + "/busybox";
        this.dockerClient.tagImageCmd("busybox:latest", imgName, tagName).exec();
        return imgName + ":" + tagName;
    }

    protected void before() throws Throwable {
        int port = 5050;
        String imageName = "private-registry-image";
        File baseDir = new File(DockerRule.class.getResource("/privateRegistry").getFile());
        String registryImageId = this.dockerClient.buildImageCmd(baseDir).withNoCache(Boolean.valueOf(true)).start().awaitImageId();
        InspectImageResponse inspectImageResponse = this.dockerClient.inspectImageCmd(registryImageId).exec();
        MatcherAssert.assertThat((Object)inspectImageResponse, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        DockerRule.LOG.info("Image Inspect: {}", (Object)inspectImageResponse.toString());
        this.dockerClient.tagImageCmd(registryImageId, imageName, "2").withForce().exec();
        CreateContainerResponse testregistry = this.dockerClient.createContainerCmd(imageName + ":2").withHostConfig(HostConfig.newHostConfig().withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindPort((int)port), ExposedPort.tcp((int)5000))})).withEnv(new String[]{"REGISTRY_AUTH=htpasswd", "REGISTRY_AUTH_HTPASSWD_REALM=Registry Realm", "REGISTRY_AUTH_HTPASSWD_PATH=/auth/htpasswd", "REGISTRY_LOG_LEVEL=debug", "REGISTRY_HTTP_TLS_CERTIFICATE=/certs/domain.crt", "REGISTRY_HTTP_TLS_KEY=/certs/domain.key"}).exec();
        this.containerId = testregistry.getId();
        this.dockerClient.startContainerCmd(this.containerId).exec();
        Thread.sleep(3000L);
        this.authConfig = new AuthConfig().withUsername("testuser").withPassword("testpassword").withRegistryAddress("localhost:" + port);
    }

    protected void after() {
        if (this.containerId != null) {
            this.dockerClient.removeContainerCmd(this.containerId).withForce(Boolean.valueOf(true)).withRemoveVolumes(Boolean.valueOf(true)).exec();
        }
    }
}

