/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.handler;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.netty.handler.FramedResponseStreamHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FramedResponseStreamHandlerTest {
    @Test
    public void channelRead0emptyHeaderCount() throws Exception {
        MockedResponseHandler responseHandler = new MockedResponseHandler();
        FramedResponseStreamHandler objectUnderTest = new FramedResponseStreamHandler((ResultCallback)responseHandler);
        byte[] msg = new byte[]{};
        objectUnderTest.channelRead0((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), Unpooled.wrappedBuffer((byte[])msg));
        Assert.assertTrue((boolean)responseHandler.frames.isEmpty());
    }

    @Test
    public void channelRead0headerTooSmall() throws Exception {
        MockedResponseHandler responseHandler = new MockedResponseHandler();
        FramedResponseStreamHandler objectUnderTest = new FramedResponseStreamHandler((ResultCallback)responseHandler);
        byte[] msg = new byte[]{0};
        objectUnderTest.channelRead0((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), Unpooled.wrappedBuffer((byte[])msg));
        Assert.assertTrue((boolean)responseHandler.frames.isEmpty());
    }

    @Test
    public void channelRead0rawStream() throws Exception {
        MockedResponseHandler responseHandler = new MockedResponseHandler();
        FramedResponseStreamHandler objectUnderTest = new FramedResponseStreamHandler((ResultCallback)responseHandler);
        byte[] msg = new byte[]{3, 0, 0, 0, 0, 0, 0, 0, 0};
        objectUnderTest.channelRead0((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), Unpooled.wrappedBuffer((byte[])msg));
        Assert.assertEquals((Object)responseHandler.frames.get(0).toString(), (Object)"RAW: ");
    }

    @Test
    public void channelRead0emptyNonRaw() throws Exception {
        MockedResponseHandler responseHandler = new MockedResponseHandler();
        FramedResponseStreamHandler objectUnderTest = new FramedResponseStreamHandler((ResultCallback)responseHandler);
        byte[] msg = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        objectUnderTest.channelRead0((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), Unpooled.wrappedBuffer((byte[])msg));
        Assert.assertTrue((boolean)responseHandler.frames.isEmpty());
    }

    @Test
    public void channelRead0stdIn() throws Exception {
        MockedResponseHandler responseHandler = new MockedResponseHandler();
        FramedResponseStreamHandler objectUnderTest = new FramedResponseStreamHandler((ResultCallback)responseHandler);
        byte[] msg = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 0};
        objectUnderTest.channelRead0((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), Unpooled.wrappedBuffer((byte[])msg));
        Assert.assertEquals((Object)responseHandler.frames.get(0).toString(), (Object)"STDIN: ");
    }

    @Test
    public void channelRead0stdOut() throws Exception {
        MockedResponseHandler responseHandler = new MockedResponseHandler();
        FramedResponseStreamHandler objectUnderTest = new FramedResponseStreamHandler((ResultCallback)responseHandler);
        byte[] msg = new byte[]{1, 0, 0, 0, 0, 0, 0, 1, 0};
        objectUnderTest.channelRead0((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), Unpooled.wrappedBuffer((byte[])msg));
        Assert.assertEquals((Object)responseHandler.frames.get(0).toString(), (Object)"STDOUT: ");
    }

    @Test
    public void channelRead0stdErr() throws Exception {
        MockedResponseHandler responseHandler = new MockedResponseHandler();
        FramedResponseStreamHandler objectUnderTest = new FramedResponseStreamHandler((ResultCallback)responseHandler);
        byte[] msg = new byte[]{2, 0, 0, 0, 0, 0, 0, 1, 0};
        objectUnderTest.channelRead0((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), Unpooled.wrappedBuffer((byte[])msg));
        Assert.assertEquals((Object)responseHandler.frames.get(0).toString(), (Object)"STDERR: ");
    }

    @Test
    public void channelRead0largePayload() throws Exception {
        MockedResponseHandler responseHandler = new MockedResponseHandler();
        FramedResponseStreamHandler objectUnderTest = new FramedResponseStreamHandler((ResultCallback)responseHandler);
        byte[] msg = new byte[]{1, 0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 0, 2, 0};
        objectUnderTest.channelRead0((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), Unpooled.wrappedBuffer((byte[])msg));
        Assert.assertEquals((Object)responseHandler.frames.get(0).toString(), (Object)"STDOUT: ");
    }

    @Test
    public void exceptionCaught() throws Exception {
        MockedResponseHandler responseHandler = new MockedResponseHandler();
        FramedResponseStreamHandler objectUnderTest = new FramedResponseStreamHandler((ResultCallback)responseHandler);
        Exception exception = new Exception();
        Throwable throwable = new Throwable();
        throwable.initCause(exception);
        objectUnderTest.exceptionCaught((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), throwable);
        Assert.assertEquals((Object)responseHandler.exceptions.get(0).getCause(), (Object)exception);
    }

    public class MockedResponseHandler
    implements ResultCallback<Frame> {
        public List<Frame> frames = new ArrayList<Frame>();
        public List<Throwable> exceptions = new ArrayList<Throwable>();

        public void close() {
        }

        public void onStart(Closeable closeable) {
        }

        public void onNext(Frame object) {
            this.frames.add(object);
        }

        public void onError(Throwable throwable) {
            this.exceptions.add(throwable);
        }

        public void onComplete() {
        }
    }
}

