/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.test.serdes;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;

public class JSONSamples {
    public static String getSampleContent(RemoteApiVersion version, String context) throws IOException {
        File resource = new File("src/test/resources/samples/" + version.getVersion() + "/" + context);
        return FileUtils.readFileToString((File)resource, (String)"UTF-8");
    }

    public static <TClass> TClass testRoundTrip(RemoteApiVersion version, String context, JavaType type) throws IOException {
        Object tObject = JSONTestHelper.getMapper().readValue(JSONSamples.getSampleContent(version, context), type);
        return (TClass)JSONSamples.testRoundTrip(tObject, type);
    }

    public static <TClass> TClass testRoundTrip(TClass item, JavaType type) throws IOException, AssertionError {
        String serialized1 = JSONTestHelper.getMapper().writeValueAsString(item);
        JsonNode json1 = JSONTestHelper.getMapper().readTree(serialized1);
        Object deserialized1 = JSONTestHelper.getMapper().readValue(serialized1, type);
        String serialized2 = JSONTestHelper.getMapper().writeValueAsString(deserialized1);
        JsonNode json2 = JSONTestHelper.getMapper().readTree(serialized2);
        Object deserialized2 = JSONTestHelper.getMapper().readValue(serialized2, type);
        Assert.assertEquals((String)"JSONs must be equal after the second roundtrip", (Object)json2, (Object)json1);
        Assert.assertEquals((String)"Objects must be equal after the second roundtrip", (Object)deserialized2, (Object)deserialized2);
        Assert.assertNotSame((String)"Objects must be not the same", (Object)deserialized2, (Object)deserialized1);
        return (TClass)deserialized2;
    }
}

