/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.test.serdes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.test.serdes.JSONResourceRef;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;

public class JSONTestHelper {
    static final ObjectMapper MAPPER;

    public static String readString(JSONResourceRef resource) throws IOException {
        try (InputStream istream = resource.getResourceClass().getResourceAsStream(resource.getFileName());){
            if (istream == null) {
                throw new IOException("Cannot retrieve resource " + resource.getFileName());
            }
            String string = IOUtils.toString((InputStream)istream, (String)"UTF-8");
            return string;
        }
    }

    public static <TClass> TClass readObject(JSONResourceRef resource, Class<TClass> tclass) throws IOException {
        String str = JSONTestHelper.readString(resource);
        return (TClass)MAPPER.readValue(str, tclass);
    }

    public static <TClass> TClass testRoundTrip(JSONResourceRef resource, Class<TClass> tclass) throws IOException, AssertionError {
        TClass item = JSONTestHelper.readObject(resource, tclass);
        Assert.assertNotNull(item);
        return JSONTestHelper.testRoundTrip(item, tclass);
    }

    public static <TClass> TClass testRoundTrip(TClass item) throws IOException, AssertionError {
        return JSONTestHelper.testRoundTrip(item, item.getClass());
    }

    public static <TClass> TClass testRoundTrip(TClass item, Class<TClass> asclass) throws IOException, AssertionError {
        String serialized1 = MAPPER.writeValueAsString(item);
        JsonNode json1 = MAPPER.readTree(serialized1);
        Object deserialized1 = MAPPER.readValue(serialized1, asclass);
        String serialized2 = MAPPER.writeValueAsString(deserialized1);
        JsonNode json2 = MAPPER.readTree(serialized2);
        Object deserialized2 = MAPPER.readValue(serialized2, asclass);
        Assert.assertEquals((String)"JSONs must be equal after the second roundtrip", (Object)json2, (Object)json1);
        return (TClass)deserialized2;
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    static {
        try {
            MAPPER = DockerClientConfig.getDefaultObjectMapper();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }
}

