/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.RemoteApiVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    public static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);

    private TestUtils() {
    }

    public static RemoteApiVersion getVersion(DockerClient client) {
        String serverVersion = ((Version)client.versionCmd().exec()).getApiVersion();
        return RemoteApiVersion.parseConfig((String)serverVersion);
    }

    public static boolean isSwarm(DockerClient client) {
        String serverVersion = ((Version)client.versionCmd().exec()).getVersion();
        return serverVersion.startsWith("swarm/");
    }

    public static boolean isNotSwarm(DockerClient client) {
        return !TestUtils.isSwarm(client);
    }

    public static Network findNetwork(List<Network> networks, String name) {
        for (Network network : networks) {
            if (!StringUtils.equals((CharSequence)network.getName(), (CharSequence)name)) continue;
            return network;
        }
        throw new AssertionError((Object)"No network found.");
    }

    public static String asString(InputStream response) {
        return TestUtils.consumeAsString(response);
    }

    public static String consumeAsString(InputStream response) {
        StringWriter logwriter = new StringWriter();
        try {
            LineIterator itr = IOUtils.lineIterator((InputStream)response, (String)"UTF-8");
            while (itr.hasNext()) {
                String line = itr.next();
                logwriter.write(line + (itr.hasNext() ? "\n" : ""));
                LOG.info("line: " + line);
            }
            response.close();
            String string = logwriter.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)response);
        }
    }
}

