/*
 * Decompiled with CFR 0.152.
 */
package com.github.gonella.gopro.api.main;

import com.github.gonella.gopro.api.core.GoProHelper;
import com.github.gonella.gopro.api.core.model.BacPacStatus;
import com.github.gonella.gopro.api.core.model.ENCameraBoss;
import com.github.gonella.gopro.api.core.model.ENCameraPowerStatus;
import com.github.gonella.gopro.api.core.model.ENCameraReady;
import com.github.gonella.gopro.api.main.LogX;

public class GoProApi {
    private static final String _10_5_5_9 = "10.5.5.9";
    public static final int _POLLINGTIME = 4000;
    public static final int _RETRY_OPERATION = 3;
    private GoProHelper helper;

    public static void main(String[] args) throws Exception {
        try {
            LogX.info("Go Pro Starting....");
            GoProApi gopro = new GoProApi("goprt4231");
            gopro.startRecord();
            gopro.stopRecord();
            gopro.stopRecordAndPowerOff();
            GoProHelper helper = gopro.getHelper();
            for (int i = 0; i < 10; ++i) {
                gopro.powerOnAndStartRecord();
                LogX.info("Waiting....8000");
                Thread.sleep(8000L);
                gopro.stopRecordAndPowerOff();
            }
            LogX.info("==== DONE ====");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void powerOnAndStartRecord() throws Exception {
        boolean goproIsReady = false;
        try {
            this.verifyIfGoProIsPowerOn();
            this.verifyIfGoProIsReadyToRecord();
            goproIsReady = true;
        }
        catch (Exception e) {
            System.out.println("The gopro is not poweron. Let try agin power on. [" + e.getMessage() + "]");
            goproIsReady = this.powerAndWaitUntilIsReady();
        }
        if (goproIsReady) {
            this.waitUntilIsReadyToReceiveCmd();
            System.out.println("Starting record");
            this.startRecord();
            System.out.println("Started.");
        }
    }

    public void stopRecordAndPowerOff() throws Exception {
        System.out.println("Stopping record");
        this.stopRecord();
        System.out.println("Stopped.");
        Thread.sleep(4000L);
        System.out.println("Power Off Go Pro");
        this.powerOff();
        System.out.println("Power Off.");
    }

    private BacPacStatus verifyIfGoProIsReadyToRecord() throws Exception {
        System.out.println("Verifying if go pro is ready...");
        BacPacStatus bacpacStatus = this.getHelper().getBacpacStatus();
        int cameraReady = bacpacStatus.getCameraReady();
        System.out.println("Camera ready \t\t? " + cameraReady);
        if (ENCameraReady.READY.getCode() != cameraReady) {
            throw new Exception("The go pro is not ready. Check if it is power on.");
        }
        return bacpacStatus;
    }

    private BacPacStatus verifyIfGoProIsPowerOn() throws Exception {
        System.out.println("Verifying if go pro is power on...");
        BacPacStatus bacpacStatus = this.getHelper().getBacpacStatus();
        int cameraPower = bacpacStatus.getCameraPower();
        System.out.println("Camera power ? " + cameraPower);
        if (ENCameraPowerStatus.POWERON.getCode() != cameraPower) {
            throw new Exception("The go pro is not power on.");
        }
        return bacpacStatus;
    }

    public boolean powerAndWaitUntilIsReady() throws Exception {
        boolean result = false;
        System.out.println("Sending power on to gopro");
        this.powerOn();
        int timeout = 0;
        for (int i = 0; i < 3; ++i) {
            try {
                this.verifyIfGoProIsReadyToRecord();
                result = true;
                break;
            }
            catch (Exception e) {
                System.out.println("Fail to check if gopro is ready. Let try again. Waiting time [4000]");
                Thread.sleep(4000L);
                ++timeout;
                continue;
            }
        }
        if (timeout == 3) {
            throw new Exception("The wait has timeout[waitUntilIsBOSSReady], check if the go pro is working correctly.");
        }
        return result;
    }

    public boolean waitUntilIsReadyToReceiveCmd() throws Exception {
        boolean result = false;
        int timeout = 0;
        for (int i = 0; i < 3; ++i) {
            try {
                this.verifyIfGoProIsReadyToReceiveCmd();
                result = true;
                break;
            }
            catch (Exception e) {
                System.out.println("Fail to check if gopro is ready. Let try again. Waiting time [4000]");
                Thread.sleep(4000L);
                ++timeout;
                continue;
            }
        }
        if (timeout == 3) {
            throw new Exception("The wait has timeout[waitUntilIsReadyToReceiveCmd], check if the go pro is working correctly.");
        }
        return result;
    }

    private BacPacStatus verifyIfGoProIsReadyToReceiveCmd() throws Exception {
        System.out.println("Verifying if go pro is ready to receive command(BOSS ready)...");
        BacPacStatus bacpacStatus = this.getHelper().getBacpacStatus();
        int bossReady = bacpacStatus.getBOSSReady();
        System.out.println("Camera BOSSReady :" + bossReady);
        if (ENCameraBoss.READY_TO_RECEIVE_CMD.getCode() != bossReady) {
            throw new Exception("The go pro is not ready to receive url cmd(i.e start record).");
        }
        return bacpacStatus;
    }

    public GoProApi(String password) {
        this.setHelper(new GoProHelper(_10_5_5_9, 80, password));
    }

    public GoProHelper getHelper() {
        return this.helper;
    }

    public void setHelper(GoProHelper helper) {
        this.helper = helper;
    }

    public void startRecord() throws Exception {
        this.getHelper().startRecord();
    }

    public void stopRecord() throws Exception {
        this.getHelper().stopRecord();
    }

    public void powerOn() throws Exception {
        this.getHelper().turnOnCamera();
    }

    public void powerOff() throws Exception {
        this.getHelper().turnOffCamera();
    }
}

