/*
 * Decompiled with CFR 0.152.
 */
package ooxml2java2d.docx.internal;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ooxml2java2d.docx.internal.FontStyle;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class FontConfig {
    private Font font = new Font("Serif", 0, 1);
    private String name = this.font.getName();
    private float size;
    private Set<FontStyle> styles = new HashSet<FontStyle>();

    public FontConfig() {
    }

    public FontConfig(FontConfig fontConfig) {
        this.setName(fontConfig.getName());
        this.setSize(fontConfig.getSize());
        for (FontStyle fs : fontConfig.getStyles()) {
            this.enableStyle(fs);
        }
    }

    public void setName(String name) {
        if (!this.font.getName().equals(name)) {
            this.name = name;
            this.font = new Font(name, this.font.getStyle(), this.font.getSize());
            this.setSize(this.size);
        }
    }

    public void setSize(float size) {
        this.size = size;
        this.font = this.font.deriveFont(size);
    }

    public void enableStyle(FontStyle style) {
        if (!this.hasStyle(style)) {
            this.styles.add(style);
            switch (style) {
                case BOLD: {
                    this.font = this.font.deriveFont(1);
                    break;
                }
                case ITALIC: {
                    this.font = this.font.deriveFont(2);
                    break;
                }
                case STRIKETHROUGH: {
                    this.font = this.setAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                    break;
                }
                case SUPERSCRIPT: {
                    this.font = this.setAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
                    break;
                }
                case UNDERLINE: {
                    this.font = this.setAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public float getSize() {
        return this.size;
    }

    public Set<FontStyle> getStyles() {
        return Collections.unmodifiableSet(this.styles);
    }

    public Rectangle2D getStringBoxSize(String text) {
        return this.font.getStringBounds(text, new FontRenderContext(this.font.getTransform(), true, true));
    }

    public Font getFont() {
        return this.font;
    }

    public boolean hasStyle(FontStyle style) {
        return this.styles.contains((Object)style);
    }

    private Font setAttribute(TextAttribute attribute, Object value) {
        Map<TextAttribute, ?> attributes = this.font.getAttributes();
        attributes.put(attribute, value);
        return this.font.deriveFont(attributes);
    }

    public int hashCode() {
        return new HashCodeBuilder(31, 15).append((Object)this.name).append(this.size).append(this.styles).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FontConfig fc = (FontConfig)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)fc.name).append(this.size, fc.size).append(this.styles, fc.styles).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("size", this.size).append("styles", this.styles).toString();
    }
}

