/*
 * Decompiled with CFR 0.152.
 */
package ooxml2java2d.docx.internal;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.io.IOException;
import ooxml2java2d.GraphicsBuilder;
import ooxml2java2d.docx.internal.FontConfig;
import ooxml2java2d.docx.internal.HAlignment;
import ooxml2java2d.docx.internal.PageInitiationAdapter;
import ooxml2java2d.docx.internal.content.BlankRow;
import ooxml2java2d.docx.internal.content.Border;
import ooxml2java2d.docx.internal.content.Column;
import ooxml2java2d.docx.internal.content.Content;
import ooxml2java2d.docx.internal.content.ImageContent;
import ooxml2java2d.docx.internal.content.Line;
import ooxml2java2d.docx.internal.content.Row;
import ooxml2java2d.docx.internal.content.StringContent;
import ooxml2java2d.docx.internal.content.TableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(GraphicsRenderer.class);
    private GraphicsBuilder builder;
    private PageInitiationAdapter initiation;
    private Graphics2D g2;
    private HAlignment hAlignment = HAlignment.LEFT;
    private int yOffset;
    private int pageWidth;
    private int pageHeight;
    private int endPosition;
    private int tableRowNesting = 0;

    public GraphicsRenderer(GraphicsBuilder builder, PageInitiationAdapter initiation) {
        this.builder = builder;
        this.initiation = initiation;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public void setEndPosition(int endPosition) {
        this.endPosition = endPosition;
    }

    public void nextPage(int pageWidth, int pageHeight) {
        this.yOffset = 0;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.endPosition = pageHeight;
        Graphics2D nextG2 = this.builder.nextPage(pageWidth, pageHeight);
        nextG2.setBackground(Color.WHITE);
        nextG2.clearRect(0, 0, pageWidth, pageHeight);
        nextG2.setColor(Color.BLACK);
        nextG2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        nextG2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        nextG2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, 250);
        if (this.g2 != null) {
            nextG2.setFont(this.g2.getFont());
            nextG2.setColor(this.g2.getColor());
        }
        this.g2 = nextG2;
        this.initiation.initiatePage();
    }

    public void renderColumn(Column column) {
        this.renderColumn(column, false, column.getContentHeight());
    }

    public void renderImage(ImageContent ic, int x, int y) {
        try {
            Image image = ic.getImage();
            if (image == null) {
                LOG.error("Error creating image for " + ic.getRelationshipId());
            } else {
                this.g2.drawImage(image, x, y, ic.getWidth(), ic.getHeight(), null);
            }
        }
        catch (IOException ioe) {
            LOG.error("Error reading image", (Throwable)ioe);
        }
    }

    private void renderColumn(Column column, boolean delayPageCreation, int contentHeight) {
        if (column.isBuffered()) {
            return;
        }
        Color origColor = this.g2.getColor();
        if (column.getFill() != null) {
            this.g2.setColor(column.getFill());
            this.g2.fillRect(column.getXOffset(), this.yOffset, column.getWidth(), contentHeight);
        }
        if (column.getTopBorder() != null) {
            Border top = column.getTopBorder();
            this.g2.setColor(top.getColor());
            this.g2.setStroke(new BasicStroke(top.getSize()));
            this.g2.drawLine(column.getXOffset(), this.yOffset, column.getXOffset() + column.getWidth(), this.yOffset);
        }
        if (column.getRightBorder() != null) {
            Border right = column.getRightBorder();
            this.g2.setColor(right.getColor());
            this.g2.setStroke(new BasicStroke(right.getSize()));
            this.g2.drawLine(column.getXOffset() + column.getWidth(), this.yOffset, column.getXOffset() + column.getWidth(), this.yOffset + contentHeight);
        }
        if (column.getBottomBorder() != null) {
            Border bottom = column.getBottomBorder();
            this.g2.setColor(bottom.getColor());
            this.g2.setStroke(new BasicStroke(bottom.getSize()));
            this.g2.drawLine(column.getXOffset(), this.yOffset + contentHeight, column.getXOffset() + column.getWidth(), this.yOffset + contentHeight);
        }
        if (column.getLeftBorder() != null) {
            Border left = column.getLeftBorder();
            this.g2.setColor(left.getColor());
            this.g2.setStroke(new BasicStroke(left.getSize()));
            this.g2.drawLine(column.getXOffset(), this.yOffset, column.getXOffset(), this.yOffset + contentHeight);
        }
        this.g2.setColor(origColor);
        switch (column.getVAlignment()) {
            case BOTTOM: {
                this.yOffset += contentHeight - column.getContentHeight();
                break;
            }
            case CENTER: {
                this.yOffset += (contentHeight - column.getContentHeight()) / 2;
                break;
            }
        }
        for (Row row : column.getRows()) {
            if (row instanceof Column) {
                Column subColumn = (Column)row;
                this.renderColumn(subColumn, delayPageCreation, row.getContentHeight());
                if (!subColumn.isEmpty()) {
                    return;
                }
            } else if (row instanceof Line) {
                if (this.yOffset + row.getContentHeight() > this.endPosition) {
                    if (delayPageCreation) {
                        return;
                    }
                    this.nextPage();
                }
                this.renderLine((Line)row, column.getXOffset());
            } else if (row instanceof BlankRow) {
                this.yOffset += row.getContentHeight();
            } else if (row instanceof TableRow) {
                TableRow tableRow = (TableRow)row;
                ++this.tableRowNesting;
                this.renderTableRow(tableRow);
                --this.tableRowNesting;
                if (this.tableRowNesting > 0) {
                    return;
                }
                if (!tableRow.isEmpty()) {
                    this.nextPage();
                    this.renderTableRow(tableRow);
                }
            } else {
                LOG.debug("Unhandled row object " + row.getClass());
            }
            column.removeRow(row);
        }
    }

    private void renderLine(Line line, int initialXOffset) {
        this.yOffset += line.getContentHeight();
        int xOffset = initialXOffset;
        switch (this.hAlignment) {
            case RIGHT: {
                xOffset += line.getWidth() - line.getContentWidth();
                break;
            }
            case CENTER: {
                xOffset += (line.getWidth() - line.getContentWidth()) / 2;
                break;
            }
        }
        for (Object obj : line.getActions()) {
            if (obj instanceof Content) {
                Content content = (Content)obj;
                if (obj instanceof StringContent) {
                    StringContent sc = (StringContent)obj;
                    this.g2.drawString(sc.getText(), xOffset, this.yOffset);
                } else if (obj instanceof ImageContent) {
                    ImageContent di = (ImageContent)obj;
                    this.renderImage(di, xOffset, this.yOffset - di.getHeight());
                } else {
                    this.yOffset += content.getHeight();
                }
                xOffset += content.getWidth();
                continue;
            }
            if (obj instanceof HAlignment) {
                this.hAlignment = (HAlignment)((Object)obj);
                continue;
            }
            if (obj instanceof Color) {
                this.g2.setColor((Color)obj);
                continue;
            }
            if (obj instanceof FontConfig) {
                FontConfig fc = (FontConfig)obj;
                this.g2.setFont(fc.getFont());
                continue;
            }
            LOG.debug("Unhandled render object " + obj.getClass());
        }
    }

    private void renderTableRow(TableRow row) {
        int start = this.yOffset;
        int contentHeight = row.getContentHeight();
        for (Column cell : row.getColumns()) {
            this.yOffset = start;
            this.renderColumn(cell, true, contentHeight);
        }
        this.yOffset = start + contentHeight;
    }

    private void nextPage() {
        this.nextPage(this.pageWidth, this.pageHeight);
    }
}

