/*
 * Decompiled with CFR 0.152.
 */
package ooxml2java2d.docx.internal;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import ooxml2java2d.docx.internal.FontConfig;
import ooxml2java2d.docx.internal.FontStyle;
import ooxml2java2d.docx.internal.HAlignment;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ParagraphStyle {
    private int lineSpacing;
    private int spaceBefore;
    private int spaceAfter;
    private int indentLeft;
    private int indentRight;
    private int indentHanging;
    private Color color = Color.BLACK;
    private FontConfig fontConfig = new FontConfig();
    private HAlignment hAlignment = HAlignment.LEFT;

    public ParagraphStyle() {
    }

    public ParagraphStyle(ParagraphStyle baseStyle) {
        this.lineSpacing = baseStyle.getLineSpacing();
        this.spaceBefore = baseStyle.getSpaceBefore();
        this.spaceAfter = baseStyle.getSpaceAfter();
        this.indentLeft = baseStyle.getIndentLeft();
        this.indentRight = baseStyle.getIndentRight();
        this.indentHanging = baseStyle.getIndentHanging();
        this.color = baseStyle.getColor();
        this.fontConfig = new FontConfig(baseStyle.getFontConfig());
        this.hAlignment = baseStyle.getHAlignment();
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public void setSpaceBefore(int spaceBefore) {
        this.spaceBefore = spaceBefore;
    }

    public void setSpaceAfter(int spaceAfter) {
        this.spaceAfter = spaceAfter;
    }

    public void setIndentLeft(int indentLeft) {
        this.indentLeft = indentLeft;
    }

    public void setIndentRight(int indentRight) {
        this.indentRight = indentRight;
    }

    public void setIndentHanging(int indentHanging) {
        this.indentHanging = indentHanging;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFontName(String name) {
        this.fontConfig.setName(name);
    }

    public void setFontSize(float size) {
        this.fontConfig.setSize(size);
    }

    public void setHAlignment(HAlignment hAlignment) {
        this.hAlignment = hAlignment;
    }

    public void enableFontStyle(FontStyle style) {
        this.fontConfig.enableStyle(style);
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public int getSpaceBefore() {
        return this.spaceBefore;
    }

    public int getSpaceAfter() {
        return this.spaceAfter;
    }

    public int getIndentLeft() {
        return this.indentLeft;
    }

    public int getIndentRight() {
        return this.indentRight;
    }

    public int getIndentHanging() {
        return this.indentHanging;
    }

    public Color getColor() {
        return this.color;
    }

    public FontConfig getFontConfig() {
        return this.fontConfig;
    }

    public HAlignment getHAlignment() {
        return this.hAlignment;
    }

    public Rectangle2D getStringBoxSize(String text) {
        return this.fontConfig.getStringBoxSize(text);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("lineSpacing", this.lineSpacing).append("spaceBefore", this.spaceBefore).append("spaceAfter", this.spaceAfter).append("indentLeft", this.indentLeft).append("indentRight", this.indentRight).append("indentHanging", this.indentHanging).append("color", (Object)this.color).append("fontConfig", (Object)this.fontConfig).append("hAlignment", (Object)this.hAlignment).toString();
    }
}

