/*
 * Decompiled with CFR 0.152.
 */
package ooxml2java2d.docx.internal.content;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import ooxml2java2d.docx.internal.VAlignment;
import ooxml2java2d.docx.internal.content.BlankRow;
import ooxml2java2d.docx.internal.content.Border;
import ooxml2java2d.docx.internal.content.Content;
import ooxml2java2d.docx.internal.content.ContentTooBigException;
import ooxml2java2d.docx.internal.content.Line;
import ooxml2java2d.docx.internal.content.Row;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Column
implements Row {
    private int xOffset;
    private int width;
    private VAlignment vAlignment;
    private Color fill;
    private Border top;
    private Border right;
    private Border bottom;
    private Border left;
    private boolean isBuffered;
    private List<Row> rows = new ArrayList<Row>();
    private Line line;

    public Column(int xOffset, int width) {
        this(xOffset, width, VAlignment.TOP, null, null, null, null, null);
    }

    public Column(int xOffset, int width, VAlignment vAlignment, Color fill, Border top, Border right, Border bottom, Border left) {
        this.xOffset = xOffset;
        this.width = width;
        this.vAlignment = vAlignment;
        this.fill = fill;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getWidth() {
        return this.width;
    }

    public VAlignment getVAlignment() {
        return this.vAlignment;
    }

    public Color getFill() {
        return this.fill;
    }

    public Border getTopBorder() {
        return this.top;
    }

    public Border getRightBorder() {
        return this.right;
    }

    public Border getBottomBorder() {
        return this.bottom;
    }

    public Border getLeftBorder() {
        return this.left;
    }

    @Override
    public int getContentHeight() {
        int height = 0;
        for (Row row : this.rows) {
            height += row.getContentHeight();
        }
        return height;
    }

    public Line getCurrentLine() {
        if (this.line == null) {
            this.line = new Line(this.width);
            this.rows.add(this.line);
        }
        return this.line;
    }

    public Row[] getRows() {
        return this.rows.toArray(new Row[this.rows.size()]);
    }

    public void setBuffered(boolean isBuffered) {
        this.isBuffered = isBuffered;
    }

    public void addVerticalSpace(int height) {
        if (height > 0) {
            this.rows.add(new BlankRow(height));
        }
        this.line = null;
    }

    public void addHorizontalSpace(int width, int verticalSpace) {
        this.addContent(new Content(width, 0), verticalSpace);
    }

    public void addContent(Content content, int verticalSpace) {
        Line currentLine = this.getCurrentLine();
        if (content.getWidth() > this.width) {
            throw new ContentTooBigException("Content too big for line");
        }
        if (!currentLine.canFitContent(content.getWidth())) {
            this.addVerticalSpace(verticalSpace);
            currentLine = this.getCurrentLine();
        }
        currentLine.addContent(content);
    }

    public void addContentForced(Content content) {
        this.getCurrentLine().addContentForced(content);
    }

    public void addRow(Row row) {
        this.addVerticalSpace(0);
        this.rows.add(row);
    }

    public void addAction(Object action) {
        this.getCurrentLine().addAction(action);
    }

    public void removeRow(Row row) {
        this.rows.remove(row);
        if (this.rows.isEmpty()) {
            this.line = null;
        }
    }

    public boolean isBuffered() {
        return this.isBuffered;
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("xOffset", this.xOffset).append("width", this.width).append("vAlignment", (Object)this.vAlignment).append("fill", (Object)this.fill).append("top", (Object)this.top).append("right", (Object)this.right).append("bottom", (Object)this.bottom).append("left", (Object)this.left).append("isBuffered", this.isBuffered).append("rows", this.rows).toString();
    }
}

