/*
 * Decompiled with CFR 0.152.
 */
package ooxml2java2d.docx.internal.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ooxml2java2d.docx.internal.content.Content;
import ooxml2java2d.docx.internal.content.ContentTooBigException;
import ooxml2java2d.docx.internal.content.Row;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Line
implements Row {
    private int width;
    private int contentWidth;
    private int contentHeight;
    private List<Object> actions = new ArrayList<Object>();

    public Line(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    @Override
    public int getContentHeight() {
        return this.contentHeight;
    }

    public List<Object> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    protected void addContent(Content content) {
        if (!this.canFitContent(content.getWidth())) {
            throw new ContentTooBigException("Content too big for line");
        }
        this.addContentForced(content);
    }

    protected void addContentForced(Content content) {
        this.contentWidth += content.getWidth();
        this.contentHeight = Math.max(this.contentHeight, content.getHeight());
        this.actions.add(content);
    }

    protected void addAction(Object action) {
        this.actions.add(action);
    }

    public boolean canFitContent(double newContentWidth) {
        return (double)this.contentWidth + newContentWidth <= (double)this.width;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("width", this.width).append("contentWidth", this.contentWidth).append("contentHeight", this.contentHeight).append("actions", this.actions).toString();
    }
}

