/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.InvalidSchemaException;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.processing.RawProcessor;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.util.AsJson;
import com.github.fge.jsonschema.core.util.ValueHolder;
import com.github.fge.jsonschema2pojo.DraftV3OnlySyntaxProcessor;
import com.google.common.io.Files;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.writer.SingleStreamCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.RuleFactory;

public final class JsonSchema2SourceCode
extends RawProcessor<SchemaTree, String> {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String CLASSNAME = "Whatever";
    private static final String PKGNAME = "com.github.fge.compiled";
    private final Processor<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> processor = new DraftV3OnlySyntaxProcessor();
    private static final GenerationConfig GENCFG = new DefaultGenerationConfig(){

        public boolean isUsePrimitives() {
            return true;
        }

        public boolean isIncludeHashcodeAndEquals() {
            return false;
        }

        public boolean isIncludeToString() {
            return false;
        }

        public boolean isIncludeJsr303Annotations() {
            return false;
        }
    };

    public JsonSchema2SourceCode() {
        super("schema", "sourceCode");
    }

    protected String rawProcess(ProcessingReport report, SchemaTree input) throws ProcessingException {
        File file;
        ValueHolder holder = ValueHolder.hold((String)"schema", (AsJson)input);
        this.processor.process(report, (MessageProvider)holder);
        if (!report.isSuccess()) {
            throw new InvalidSchemaException(new ProcessingMessage().setMessage("invalid schema, cannot continue"));
        }
        JsonNode schema = input.getBaseNode();
        JCodeModel model = new JCodeModel();
        Jackson2Annotator annotator = new Jackson2Annotator(GENCFG);
        SchemaStore store = new SchemaStore();
        RuleFactory ruleFactory = new RuleFactory(GENCFG, (Annotator)annotator, store);
        SchemaMapper mapper = new SchemaMapper(ruleFactory, new SchemaGenerator());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SingleStreamCodeWriter writer = new SingleStreamCodeWriter((OutputStream)out);
        try {
            file = JsonSchema2SourceCode.schemaToFile(schema);
        }
        catch (IOException e) {
            throw new ProcessingException("cannot create file", (Throwable)e);
        }
        try {
            mapper.generate(model, CLASSNAME, PKGNAME, file.toURI().toURL());
            model.build((CodeWriter)writer);
            String e = out.toString("UTF-8");
            return e;
        }
        catch (IOException e) {
            throw new ProcessingException("failed to generate source", (Throwable)e);
        }
        finally {
            if (!file.delete()) {
                report.warn(this.newMessage(input).setMessage("cannot delete file"));
            }
        }
    }

    private static File schemaToFile(JsonNode schema) throws IOException {
        File ret = File.createTempFile("schema", ".json");
        byte[] content = schema.toString().getBytes(UTF8);
        Files.write((byte[])content, (File)ret);
        return ret;
    }
}

