/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.tools;

import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdApi;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.tools.RDF4JJSONLDRDFParser;
import com.github.jsonldjava.tools.RDF4JJSONLDTripleCallback;
import com.github.jsonldjava.utils.JarCacheStorage;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.Rio;

public class Playground {
    public static void main(String[] args) throws Exception {
        final Map<String, RDFFormat> formats = Playground.getOutputFormats();
        final LinkedHashSet<String> outputForms = new LinkedHashSet<String>(Arrays.asList("compacted", "expanded", "flattened"));
        OptionParser parser = new OptionParser();
        AbstractOptionSpec help = parser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec base = parser.accepts("base").withRequiredArg().ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]).describedAs("base URI");
        ArgumentAcceptingOptionSpec inputFile = parser.accepts("inputFile").withRequiredArg().ofType(File.class).required().describedAs("The input file");
        ArgumentAcceptingOptionSpec context = parser.accepts("context").withRequiredArg().ofType(File.class).describedAs("The context");
        ArgumentAcceptingOptionSpec outputFormat = parser.accepts("format").withOptionalArg().ofType(String.class).withValuesConvertedBy((ValueConverter)new ValueConverter<RDFFormat>(){

            public RDFFormat convert(String inputFormat) {
                String formatName = inputFormat.replaceAll("-", "").replaceAll("/", "").toLowerCase();
                if (formats.containsKey(formatName)) {
                    return (RDFFormat)formats.get(formatName);
                }
                throw new ValueConversionException("Format was not known: " + inputFormat + " (Valid values are: " + formats.keySet() + ")");
            }

            public String valuePattern() {
                return null;
            }

            public Class<RDFFormat> valueType() {
                return RDFFormat.class;
            }
        }).defaultsTo((Object)RDFFormat.NQUADS, (Object[])new RDFFormat[0]).describedAs("The output file format to use. Defaults to nquads. Valid values are: " + formats.keySet());
        ArgumentAcceptingOptionSpec processingOption = parser.accepts("process").withRequiredArg().ofType(String.class).required().withValuesConvertedBy((ValueConverter)new ValueConverter<String>(){

            public String convert(String value) {
                if (Playground.getProcessingOptions().contains(value.toLowerCase())) {
                    return value.toLowerCase();
                }
                throw new ValueConversionException("Processing option was not known: " + value + " (Valid values are: " + Playground.getProcessingOptions() + ")");
            }

            public Class<String> valueType() {
                return String.class;
            }

            public String valuePattern() {
                return null;
            }
        }).describedAs("The processing to perform. Valid values are: " + Playground.getProcessingOptions().toString());
        ArgumentAcceptingOptionSpec outputForm = parser.accepts("outputForm").withOptionalArg().ofType(String.class).defaultsTo((Object)"expanded", (Object[])new String[0]).withValuesConvertedBy((ValueConverter)new ValueConverter<String>(){

            public String convert(String value) {
                if (outputForms.contains(value.toLowerCase())) {
                    return value.toLowerCase();
                }
                throw new ValueConversionException("Output form was not known: " + value + " (Valid values are: " + outputForms + ")");
            }

            public String valuePattern() {
                return null;
            }

            public Class<String> valueType() {
                return String.class;
            }
        }).describedAs("The way to output the results from fromRDF. Defaults to expanded. Valid values are: " + outputForms);
        ArgumentAcceptingOptionSpec usernameOption = parser.accepts("username").withOptionalArg().ofType(String.class).describedAs("username for basic authentication credentials");
        ArgumentAcceptingOptionSpec passwordOption = parser.accepts("password").withOptionalArg().ofType(String.class).describedAs("password for basic authentication credentials (defaults to value of 'PASSWORD' environment property, if set, or empty string otherwise)");
        ArgumentAcceptingOptionSpec authHostOption = parser.accepts("authHost").withOptionalArg().ofType(String.class).defaultsTo((Object)"localhost", (Object[])new String[0]).describedAs("host authentication scope");
        ArgumentAcceptingOptionSpec authPortOption = parser.accepts("authPort").withOptionalArg().ofType(Integer.class).defaultsTo((Object)443, (Object[])new Integer[0]).describedAs("host port authentication scope");
        OptionSpecBuilder authInsecureOption = parser.accepts("insecure", "Similar to `curl -k` or `curl --insecure`: if unspecified, all SSL connections are secure by default; if specified, trust everything (do not use for production!)");
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (OptionException e) {
            System.out.println(e.getMessage());
            parser.printHelpOn((OutputStream)System.out);
            throw e;
        }
        if (options.has((OptionSpec)help)) {
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        JsonLdOptions opts = new JsonLdOptions("");
        Object inobj = null;
        Object ctxobj = null;
        opts.setBase((String)options.valueOf((OptionSpec)base));
        opts.outputForm = (String)options.valueOf((OptionSpec)outputForm);
        opts.format = options.has((OptionSpec)outputFormat) ? ((RDFFormat)options.valueOf((OptionSpec)outputFormat)).getDefaultMIMEType() : "application/n-quads";
        RDFFormat sesameOutputFormat = (RDFFormat)options.valueOf((OptionSpec)outputFormat);
        RDFFormat sesameInputFormat = Rio.getParserFormatForFileName((String)((File)options.valueOf((OptionSpec)inputFile)).getName()).orElse(RDFFormat.JSONLD);
        String processingOptionValue = (String)options.valueOf((OptionSpec)processingOption);
        if (!((File)options.valueOf((OptionSpec)inputFile)).exists()) {
            System.out.println("Error: input file \"" + options.valueOf((OptionSpec)inputFile) + "\" doesn't exist");
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        if (opts.getBase() == null || opts.getBase().equals("")) {
            opts.setBase(((File)options.valueOf((OptionSpec)inputFile)).toURI().toASCIIString());
        }
        if (options.hasArgument((OptionSpec)usernameOption)) {
            String username = (String)options.valueOf((OptionSpec)usernameOption);
            String envPassword = System.getenv("PASSWORD");
            String password = options.hasArgument((OptionSpec)passwordOption) ? (String)options.valueOf((OptionSpec)passwordOption) : (null != envPassword ? envPassword : "");
            String authHost = (String)options.valueOf((OptionSpec)authHostOption);
            Integer authPort = (Integer)options.valueOf((OptionSpec)authPortOption);
            DocumentLoader documentLoader = new DocumentLoader();
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(authHost, authPort.intValue()), (Credentials)new UsernamePasswordCredentials(username, password));
            CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).build();
            HttpClientBuilder builder = CachingHttpClientBuilder.create().setCacheConfig(cacheConfig).setHttpCacheStorage((HttpCacheStorage)new JarCacheStorage(null, cacheConfig, (HttpCacheStorage)new BasicHttpCacheStorage(cacheConfig))).setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            if (options.has((OptionSpec)authInsecureOption)) {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, new TrustManager[]{new InsecureX509TrustManager()}, null);
                HostnameVerifier v = new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                };
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(ctx, v);
                builder = builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            }
            documentLoader.setHttpClient(builder.build());
            opts.setDocumentLoader(documentLoader);
        }
        inobj = "fromrdf".equals(processingOptionValue) ? Playground.readFile((File)options.valueOf((OptionSpec)inputFile)) : JsonUtils.fromInputStream((InputStream)new FileInputStream((File)options.valueOf((OptionSpec)inputFile)));
        if (Playground.hasContext(processingOptionValue) && options.has((OptionSpec)context)) {
            if (!((File)options.valueOf((OptionSpec)context)).exists()) {
                System.out.println("Error: context file \"" + options.valueOf((OptionSpec)context) + "\" doesn't exist");
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            ctxobj = JsonUtils.fromInputStream((InputStream)new FileInputStream((File)options.valueOf((OptionSpec)context)));
        }
        Object outobj = null;
        if ("fromrdf".equals(processingOptionValue)) {
            Model inModel = Rio.parse((Reader)new StringReader((String)inobj), (String)opts.getBase(), (RDFFormat)sesameInputFormat, (Resource[])new Resource[0]);
            outobj = JsonLdProcessor.fromRDF((Object)inModel, (JsonLdOptions)opts, (RDFParser)new RDF4JJSONLDRDFParser());
        } else if ("tordf".equals(processingOptionValue)) {
            opts.useNamespaces = true;
            outobj = JsonLdProcessor.toRDF((Object)inobj, (JsonLdTripleCallback)new RDF4JJSONLDTripleCallback((RDFHandler)Rio.createWriter((RDFFormat)sesameOutputFormat, (OutputStream)System.out)), (JsonLdOptions)opts);
        } else if ("expand".equals(processingOptionValue)) {
            outobj = JsonLdProcessor.expand((Object)inobj, (JsonLdOptions)opts);
        } else if ("compact".equals(processingOptionValue)) {
            if (ctxobj == null) {
                System.out.println("Error: The compaction context must not be null.");
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            outobj = JsonLdProcessor.compact((Object)inobj, (Object)ctxobj, (JsonLdOptions)opts);
        } else if ("normalize".equals(processingOptionValue)) {
            opts.format = null;
            Object result = JsonLdProcessor.toRDF((Object)inobj, (JsonLdTripleCallback)(options.has((OptionSpec)outputFormat) ? new RDF4JJSONLDTripleCallback((RDFHandler)Rio.createWriter((RDFFormat)sesameOutputFormat, (OutputStream)System.out)) : null), (JsonLdOptions)opts);
            if (RDFDataset.class.isInstance(result)) {
                RDFDataset rdfds = (RDFDataset)RDFDataset.class.cast(result);
                outobj = new JsonLdApi(opts).normalize((Map)rdfds);
            } else {
                outobj = result;
            }
        } else if ("frame".equals(processingOptionValue)) {
            if (ctxobj != null && !(ctxobj instanceof Map)) {
                System.out.println("Invalid JSON-LD syntax; a JSON-LD frame must be a single object.");
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            outobj = JsonLdProcessor.frame((Object)inobj, (Object)ctxobj, (JsonLdOptions)opts);
        } else if ("flatten".equals(processingOptionValue)) {
            outobj = JsonLdProcessor.flatten((Object)inobj, (Object)ctxobj, (JsonLdOptions)opts);
        } else {
            System.out.println("Error: invalid processing option \"" + processingOptionValue + "\"");
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        if (!"tordf".equals(processingOptionValue)) {
            if ("normalize".equals(processingOptionValue)) {
                if (!options.has((OptionSpec)outputFormat)) {
                    System.out.println(JsonUtils.toPrettyString((Object)outobj));
                }
            } else {
                System.out.println(JsonUtils.toPrettyString((Object)outobj));
            }
        }
    }

    private static Set<String> getProcessingOptions() {
        return new LinkedHashSet<String>(Arrays.asList("expand", "compact", "frame", "normalize", "flatten", "fromrdf", "tordf"));
    }

    private static boolean hasContext(String opt) {
        return "compact".equals(opt) || "frame".equals(opt) || "flatten".equals(opt);
    }

    private static Map<String, RDFFormat> getOutputFormats() {
        HashMap<String, RDFFormat> outputFormats = new HashMap<String, RDFFormat>();
        for (RDFFormat format : RDFParserRegistry.getInstance().getKeys()) {
            outputFormats.put(format.getName().replaceAll("-", "").replaceAll("/", "").toLowerCase(), format);
        }
        return outputFormats;
    }

    private static String readFile(File in) throws IOException {
        StringBuilder inobj = new StringBuilder(1024);
        try (BufferedReader buf = Files.newBufferedReader(in.toPath(), StandardCharsets.UTF_8);){
            String line;
            while ((line = buf.readLine()) != null) {
                line = line.trim();
                inobj.append(line).append('\n');
            }
        }
        return inobj.toString();
    }

    private static class InsecureX509TrustManager
    extends X509ExtendedTrustManager
    implements X509TrustManager {
        private InsecureX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] xcs, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        }
    }
}

