/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.cronparser.domain.notation;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import uk.co.mruoc.cronparser.domain.TimeUnit;
import uk.co.mruoc.cronparser.domain.notation.InvalidNotationException;
import uk.co.mruoc.cronparser.domain.notation.NotationParser;
import uk.co.mruoc.cronparser.domain.notation.StringUtil;

public class SimpleNotationParser
implements NotationParser {
    @Override
    public boolean appliesTo(String input) {
        return SimpleNotationParser.split(input).allMatch(StringUtil::isInt);
    }

    @Override
    public int[] toValues(String input, TimeUnit unit) {
        int[] values = SimpleNotationParser.toIntegers(input);
        unit.validate(values);
        return values;
    }

    private static int[] toIntegers(String input) {
        return SimpleNotationParser.split(input).mapToInt(SimpleNotationParser::toInteger).toArray();
    }

    private static int toInteger(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            throw new InvalidNotationException(input, e);
        }
    }

    private static Stream<String> split(String input) {
        return Arrays.stream(StringUtils.split((String)input, (String)","));
    }
}

