/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.client;

import com.mpush.api.Logger;
import com.mpush.api.MessageHandler;
import com.mpush.api.PacketReceiver;
import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Command;
import com.mpush.api.protocol.Packet;
import com.mpush.client.ClientConfig;
import com.mpush.handler.ErrorMessageHandler;
import com.mpush.handler.FastConnectOkHandler;
import com.mpush.handler.HandshakeOkHandler;
import com.mpush.handler.HeartbeatHandler;
import com.mpush.handler.KickUserHandler;
import com.mpush.handler.OkMessageHandler;
import com.mpush.handler.PushMessageHandler;
import com.mpush.util.thread.ExecutorManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public final class MessageDispatcher
implements PacketReceiver {
    private final Executor executor = ExecutorManager.INSTANCE.getDispatchThread();
    private final Map<Byte, MessageHandler> handlers = new HashMap<Byte, MessageHandler>();
    private final Logger logger = ClientConfig.I.getLogger();

    public MessageDispatcher() {
        this.register(Command.HEARTBEAT, new HeartbeatHandler());
        this.register(Command.FAST_CONNECT, new FastConnectOkHandler());
        this.register(Command.HANDSHAKE, new HandshakeOkHandler());
        this.register(Command.KICK, new KickUserHandler());
        this.register(Command.OK, new OkMessageHandler());
        this.register(Command.ERROR, new ErrorMessageHandler());
        this.register(Command.PUSH, new PushMessageHandler());
    }

    public void register(Command command, MessageHandler handler) {
        this.handlers.put(command.cmd, handler);
    }

    @Override
    public void onReceive(final Packet packet, final Connection connection) {
        final MessageHandler handler = this.handlers.get(packet.cmd);
        if (handler != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        handler.handle(packet, connection);
                    }
                    catch (Throwable throwable) {
                        MessageDispatcher.this.logger.e(throwable, "handle message error, packet=%s", packet);
                        connection.reconnect();
                    }
                }
            });
        } else {
            this.logger.w("<<< receive unsupported message, do reconnect, packet=%s", packet);
            connection.reconnect();
        }
    }
}

