/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.message;

import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Command;
import com.mpush.api.protocol.Packet;
import com.mpush.message.ByteBufMessage;
import com.mpush.util.ByteBuf;
import java.nio.ByteBuffer;

public final class BindUserMessage
extends ByteBufMessage {
    public String userId;
    public String alias;
    public String tags;

    private BindUserMessage(Command cmd, Connection connection) {
        super(new Packet(cmd, BindUserMessage.genSessionId()), connection);
    }

    public static BindUserMessage buildBind(Connection connection) {
        return new BindUserMessage(Command.BIND, connection);
    }

    public static BindUserMessage buildUnbind(Connection connection) {
        return new BindUserMessage(Command.UNBIND, connection);
    }

    @Override
    public void decode(ByteBuffer body) {
        this.userId = this.decodeString(body);
        this.alias = this.decodeString(body);
        this.tags = this.decodeString(body);
    }

    @Override
    public void encode(ByteBuf body) {
        this.encodeString(body, this.userId);
        this.encodeString(body, this.alias);
        this.encodeString(body, this.tags);
    }

    public BindUserMessage setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public BindUserMessage setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public BindUserMessage setTags(String tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public String toString() {
        return "BindUserMessage{userId='" + this.userId + '\'' + ", alias='" + this.alias + '\'' + ", tags='" + this.tags + '\'' + '}';
    }
}

