/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.protocol;

import com.mpush.api.protocol.Command;
import java.nio.ByteBuffer;

public final class Packet {
    public static final int HEADER_LEN = 13;
    public static final byte FLAG_CRYPTO = 1;
    public static final byte FLAG_COMPRESS = 2;
    public static final byte FLAG_BIZ_ACK = 4;
    public static final byte FLAG_AUTO_ACK = 8;
    public static final byte HB_PACKET_BYTE = -33;
    public static final Packet HB_PACKET = new Packet(Command.HEARTBEAT);
    public byte cmd;
    public short cc;
    public byte flags;
    public int sessionId;
    public byte lrc;
    public byte[] body;

    public Packet(byte cmd) {
        this.cmd = cmd;
    }

    public Packet(byte cmd, int sessionId) {
        this.cmd = cmd;
        this.sessionId = sessionId;
    }

    public Packet(Command cmd) {
        this.cmd = cmd.cmd;
    }

    public Packet(Command cmd, int sessionId) {
        this.cmd = cmd.cmd;
        this.sessionId = sessionId;
    }

    public int getBodyLength() {
        return this.body == null ? 0 : this.body.length;
    }

    public void addFlag(byte flag) {
        this.flags = (byte)(this.flags | flag);
    }

    public boolean hasFlag(byte flag) {
        return (this.flags & flag) == flag;
    }

    public short calcCheckCode() {
        short checkCode = 0;
        if (this.body != null) {
            for (int i = 0; i < this.body.length; ++i) {
                checkCode = (short)(checkCode + (this.body[i] & 0xFF));
            }
        }
        return checkCode;
    }

    public byte calcLrc() {
        byte[] data = ByteBuffer.allocate(12).putInt(this.getBodyLength()).put(this.cmd).putShort(this.cc).put(this.flags).putInt(this.sessionId).array();
        byte lrc = 0;
        for (int i = 0; i < data.length; ++i) {
            lrc = (byte)(lrc ^ data[i]);
        }
        return lrc;
    }

    public boolean validCheckCode() {
        return this.calcCheckCode() == this.cc;
    }

    public boolean validLrc() {
        return (this.lrc ^ this.calcLrc()) == 0;
    }

    public String toString() {
        return "Packet{cmd=" + this.cmd + ", cc=" + this.cc + ", flags=" + this.flags + ", sessionId=" + this.sessionId + ", lrc=" + this.lrc + ", body=" + (this.body == null ? 0 : this.body.length) + '}';
    }
}

