/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service;

import internal.nbbrd.service.com.github.javaparser.ParseProblemException;
import internal.nbbrd.service.com.github.javaparser.StaticJavaParser;
import internal.nbbrd.service.com.github.javaparser.ast.CompilationUnit;
import internal.nbbrd.service.com.github.javaparser.ast.NodeList;
import internal.nbbrd.service.com.github.javaparser.ast.modules.ModuleDirective;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lombok.Generated;

public final class ModuleInfoEntries {
    private final List<String> usages;
    private final Map<String, List<String>> provisions;

    public static Optional<ModuleInfoEntries> parse(Filer filer, Elements elements) throws IOException {
        try {
            FileObject src = filer.getResource(StandardLocation.SOURCE_PATH, "", "module-info.java");
            return ModuleInfoEntries.parse(src.getCharContent(false), PackageExpander.of(elements));
        }
        catch (FileNotFoundException | RuntimeException | NoSuchFileException | FilerException ex) {
            return Optional.empty();
        }
    }

    static Optional<ModuleInfoEntries> parse(CharSequence moduleInfoContent, PackageExpander expander) {
        try {
            return ModuleInfoEntries.parse(StaticJavaParser.parse(moduleInfoContent.toString()), expander);
        }
        catch (ParseProblemException ex) {
            return Optional.empty();
        }
    }

    private static Optional<ModuleInfoEntries> parse(CompilationUnit compilationUnit, PackageExpander expander) {
        List<String> imports = ModuleInfoEntries.parseImports(compilationUnit, expander);
        return compilationUnit.getModule().map(moduleDeclaration -> ModuleInfoEntries.parseDirectives(imports, moduleDeclaration.getDirectives()));
    }

    private static List<String> parseImports(CompilationUnit compilationUnit, PackageExpander expander) {
        return compilationUnit.getImports().stream().flatMap(importDeclaration -> importDeclaration.isAsterisk() ? expander.getEnclosedTypeNames(importDeclaration.getNameAsString()) : Stream.of(importDeclaration.getNameAsString())).collect(Collectors.toList());
    }

    private static ModuleInfoEntries parseDirectives(List<String> imports, NodeList<ModuleDirective> directives) {
        Builder result = ModuleInfoEntries.builder();
        directives.forEach(directive -> {
            directive.ifModuleProvidesDirective(provides -> provides.getWith().forEach(z -> result.provision(ModuleInfoEntries.resolveTypeName(imports, provides.getNameAsString()), ModuleInfoEntries.resolveTypeName(imports, z.asString()))));
            directive.ifModuleUsesDirective(uses -> result.usage(ModuleInfoEntries.resolveTypeName(imports, uses.getNameAsString())));
        });
        return result.build();
    }

    private static String resolveTypeName(List<String> imports, String input) {
        String expected = "." + input.split("\\.", -1)[0];
        return imports.stream().filter(importDecl -> importDecl.endsWith(expected)).map(o -> o.substring(0, o.lastIndexOf(expected)) + "." + input).findFirst().orElse(input);
    }

    @Generated
    private static Map<String, List<String>> $default$provisions() {
        return Collections.emptyMap();
    }

    @Generated
    ModuleInfoEntries(List<String> usages, Map<String, List<String>> provisions) {
        this.usages = usages;
        this.provisions = provisions;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public List<String> getUsages() {
        return this.usages;
    }

    @Generated
    public Map<String, List<String>> getProvisions() {
        return this.provisions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleInfoEntries)) {
            return false;
        }
        ModuleInfoEntries other = (ModuleInfoEntries)o;
        List<String> this$usages = this.getUsages();
        List<String> other$usages = other.getUsages();
        if (this$usages == null ? other$usages != null : !((Object)this$usages).equals(other$usages)) {
            return false;
        }
        Map<String, List<String>> this$provisions = this.getProvisions();
        Map<String, List<String>> other$provisions = other.getProvisions();
        return !(this$provisions == null ? other$provisions != null : !((Object)this$provisions).equals(other$provisions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $usages = this.getUsages();
        result = result * 59 + ($usages == null ? 43 : ((Object)$usages).hashCode());
        Map<String, List<String>> $provisions = this.getProvisions();
        result = result * 59 + ($provisions == null ? 43 : ((Object)$provisions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ModuleInfoEntries(usages=" + this.getUsages() + ", provisions=" + this.getProvisions() + ")";
    }

    static interface PackageExpander {
        public Stream<String> getEnclosedTypeNames(String var1);

        public static PackageExpander of(Elements elements) {
            return packageName -> {
                PackageElement packageElement = elements.getPackageElement(packageName);
                return packageElement != null ? packageElement.getEnclosedElements().stream().filter(TypeElement.class::isInstance).map(TypeElement.class::cast).map(TypeElement::getQualifiedName).map(Object::toString) : Stream.empty();
            };
        }
    }

    public static class Builder {
        @Generated
        private ArrayList<String> usages;
        @Generated
        private boolean provisions$set;
        @Generated
        private Map<String, List<String>> provisions$value;

        public Builder provision(String key, String value) {
            if (!this.provisions$set) {
                this.provisions$set = true;
                this.provisions$value = new HashMap<String, List<String>>();
            }
            this.provisions$value.computeIfAbsent(key, o -> new ArrayList()).add(value);
            return this;
        }

        @Generated
        Builder() {
        }

        @Generated
        public Builder usage(String usage) {
            if (this.usages == null) {
                this.usages = new ArrayList();
            }
            this.usages.add(usage);
            return this;
        }

        @Generated
        public Builder usages(Collection<? extends String> usages) {
            if (usages == null) {
                throw new NullPointerException("usages cannot be null");
            }
            if (this.usages == null) {
                this.usages = new ArrayList();
            }
            this.usages.addAll(usages);
            return this;
        }

        @Generated
        public Builder clearUsages() {
            if (this.usages != null) {
                this.usages.clear();
            }
            return this;
        }

        @Generated
        public Builder provisions(Map<String, List<String>> provisions) {
            this.provisions$value = provisions;
            this.provisions$set = true;
            return this;
        }

        @Generated
        public ModuleInfoEntries build() {
            List<String> usages;
            switch (this.usages == null ? 0 : this.usages.size()) {
                case 0: {
                    usages = Collections.emptyList();
                    break;
                }
                case 1: {
                    usages = Collections.singletonList(this.usages.get(0));
                    break;
                }
                default: {
                    usages = Collections.unmodifiableList(new ArrayList<String>(this.usages));
                }
            }
            Map provisions$value = this.provisions$value;
            if (!this.provisions$set) {
                provisions$value = ModuleInfoEntries.$default$provisions();
            }
            return new ModuleInfoEntries(usages, provisions$value);
        }

        @Generated
        public String toString() {
            return "ModuleInfoEntries.Builder(usages=" + this.usages + ", provisions$value=" + this.provisions$value + ")";
        }
    }
}

