/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.sql.jdbc.SqlConnectionSupplier;
import nbbrd.sql.jdbc.SqlFunc;

public final class DriverManagerSupplier
implements SqlConnectionSupplier {
    @NonNull
    private final String driverClassName;
    @NonNull
    private final SqlFunc<String, String> toUrl;

    @Override
    public Connection getConnection(String connectionString) throws SQLException {
        Objects.requireNonNull(connectionString);
        if (!SqlConnectionSupplier.isDriverLoadable(this.driverClassName)) {
            throw new SQLException("Can't load jdbc driver '" + this.driverClassName + "'");
        }
        return this.toUrl.andThen(DriverManager::getConnection).applyWithSql(connectionString);
    }

    @Generated
    public DriverManagerSupplier(@NonNull String driverClassName, @NonNull SqlFunc<String, String> toUrl) {
        if (driverClassName == null) {
            throw new NullPointerException("driverClassName is marked non-null but is null");
        }
        if (toUrl == null) {
            throw new NullPointerException("toUrl is marked non-null but is null");
        }
        this.driverClassName = driverClassName;
        this.toUrl = toUrl;
    }
}

