/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.sql.jdbc.SqlConnectionSupplier;

public final class JndiSupplier
implements SqlConnectionSupplier {
    @NonNull
    private final Callable<? extends Context> contextSupplier;

    @Override
    public Connection getConnection(String connectionString) throws SQLException {
        Objects.requireNonNull(connectionString);
        return this.lookupByName(connectionString).getConnection();
    }

    private DataSource lookupByName(String name) throws SQLException {
        try {
            Context ctx = this.getContext();
            return (DataSource)ctx.lookup(name);
        }
        catch (ClassCastException | NamingException ex) {
            throw new SQLException("Cannot retrieve javax.sql.DataSource for '" + name + "'", ex);
        }
    }

    private Context getContext() throws SQLException {
        try {
            return this.contextSupplier.call();
        }
        catch (Exception ex) {
            throw new SQLException("Cannot retrieve context", ex);
        }
    }

    @Generated
    public JndiSupplier(@NonNull Callable<? extends Context> contextSupplier) {
        if (contextSupplier == null) {
            throw new NullPointerException("contextSupplier is marked non-null but is null");
        }
        this.contextSupplier = contextSupplier;
    }
}

