/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.jdbc;

import internal.sql.jdbc.DataSourceBasedSupplier;
import internal.sql.jdbc.DriverManagerSupplier;
import internal.sql.jdbc.JndiSupplier;
import internal.sql.jdbc.NoOpSupplier;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import nbbrd.sql.jdbc.SqlFunc;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface SqlConnectionSupplier {
    public @NonNull Connection getConnection(@NonNull String var1) throws SQLException;

    public static @NonNull SqlConnectionSupplier ofDriverManager(@NonNull String driverClassName, @NonNull SqlFunc<String, String> toUrl) {
        return new DriverManagerSupplier(driverClassName, toUrl);
    }

    public static @NonNull SqlConnectionSupplier ofDataSource(@NonNull SqlFunc<String, DataSource> toDataSource) {
        return new DataSourceBasedSupplier(toDataSource);
    }

    public static @NonNull SqlConnectionSupplier ofJndi() {
        return new JndiSupplier(InitialContext::new);
    }

    public static @NonNull SqlConnectionSupplier noOp() {
        return NoOpSupplier.INSTANCE;
    }

    public static boolean isDriverLoadable(@NonNull String driverClassName) {
        try {
            return Driver.class.isAssignableFrom(Class.forName(driverClassName));
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean isDriverRegistered(@NonNull String driverClassName) {
        return Collections.list(DriverManager.getDrivers()).stream().map(o -> o.getClass().getName()).anyMatch(driverClassName::equals);
    }
}

