/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.jdbc;

import internal.sql.jdbc.DataSourceBasedSupplier;
import internal.sql.jdbc.DriverManagerSupplier;
import internal.sql.jdbc.JndiSupplier;
import internal.sql.jdbc.NoOpSupplier;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import lombok.NonNull;
import nbbrd.sql.jdbc.SqlFunc;

public interface SqlConnectionSupplier {
    @NonNull
    public Connection getConnection(@NonNull String var1) throws SQLException;

    @NonNull
    public static SqlConnectionSupplier ofDriverManager(@NonNull String driverClassName, @NonNull SqlFunc<String, String> toUrl) {
        if (driverClassName == null) {
            throw new NullPointerException("driverClassName is marked non-null but is null");
        }
        if (toUrl == null) {
            throw new NullPointerException("toUrl is marked non-null but is null");
        }
        return new DriverManagerSupplier(driverClassName, toUrl);
    }

    @NonNull
    public static SqlConnectionSupplier ofDataSource(@NonNull SqlFunc<String, DataSource> toDataSource) {
        if (toDataSource == null) {
            throw new NullPointerException("toDataSource is marked non-null but is null");
        }
        return new DataSourceBasedSupplier(toDataSource);
    }

    @NonNull
    public static SqlConnectionSupplier ofJndi() {
        return new JndiSupplier(InitialContext::new);
    }

    @NonNull
    public static SqlConnectionSupplier noOp() {
        return NoOpSupplier.INSTANCE;
    }

    public static boolean isDriverLoadable(@NonNull String driverClassName) {
        if (driverClassName == null) {
            throw new NullPointerException("driverClassName is marked non-null but is null");
        }
        try {
            return Driver.class.isAssignableFrom(Class.forName(driverClassName));
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean isDriverRegistered(@NonNull String driverClassName) {
        if (driverClassName == null) {
            throw new NullPointerException("driverClassName is marked non-null but is null");
        }
        return Collections.list(DriverManager.getDrivers()).stream().map(o -> o.getClass().getName()).anyMatch(driverClassName::equals);
    }
}

