/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder;

import com.github.scribejava.core.builder.AbstractServiceBuilder;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.oauth.OAuthService;
import com.github.scribejava.core.utils.Preconditions;

public class ServiceBuilder
extends AbstractServiceBuilder<ServiceBuilder> {
    private Integer connectTimeout;
    private Integer readTimeout;

    public ServiceBuilder connectTimeout(Integer connectTimeout) {
        Preconditions.checkNotNull(connectTimeout, "Connection timeout can't be null");
        this.connectTimeout = connectTimeout;
        return this;
    }

    public ServiceBuilder readTimeout(Integer readTimeout) {
        Preconditions.checkNotNull(readTimeout, "Read timeout can't be null");
        this.readTimeout = readTimeout;
        return this;
    }

    public OAuthService build() {
        super.checkPreconditions();
        OAuthConfig config = new OAuthConfig(this.getApiKey(), this.getApiSecret(), this.getCallback(), this.getSignatureType(), this.getScope(), this.getDebugStream(), this.connectTimeout, this.readTimeout, this.getGrantType());
        config.setState(this.getState());
        return this.getApi().createService(config);
    }
}

