/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.ForceTypeOfHttpRequest;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.ScribeJavaConfig;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;

public abstract class OAuthService {
    private final OAuthConfig config;
    private final AsyncHttpClient asyncHttpClient;

    public OAuthService(OAuthConfig config) {
        this.config = config;
        ForceTypeOfHttpRequest forceTypeOfHttpRequest = ScribeJavaConfig.getForceTypeOfHttpRequests();
        AsyncHttpClientConfig asyncHttpClientConfig = config.getAsyncHttpClientConfig();
        if (asyncHttpClientConfig == null) {
            if (ForceTypeOfHttpRequest.FORCE_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                throw new OAuthException("Cannot use sync operations, only async");
            }
            if (ForceTypeOfHttpRequest.PREFER_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                config.log("Cannot use sync operations, only async");
            }
            this.asyncHttpClient = null;
        } else {
            String asyncHttpProviderClassName;
            if (ForceTypeOfHttpRequest.FORCE_SYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                throw new OAuthException("Cannot use async operations, only sync");
            }
            if (ForceTypeOfHttpRequest.PREFER_SYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                config.log("Cannot use async operations, only sync");
            }
            this.asyncHttpClient = (asyncHttpProviderClassName = config.getAsyncHttpProviderClassName()) == null ? new AsyncHttpClient(asyncHttpClientConfig) : new AsyncHttpClient(asyncHttpProviderClassName, asyncHttpClientConfig);
        }
    }

    public AsyncHttpClient getAsyncHttpClient() {
        return this.asyncHttpClient;
    }

    public void closeAsyncClient() {
        this.asyncHttpClient.close();
    }

    public OAuthConfig getConfig() {
        return this.config;
    }

    public abstract String getVersion();
}

