/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.utils;

import com.github.scribejava.core.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class StreamUtilsTest {
    private static final InputStream ALLWAYS_ERROR_INPUT_STREAM = new AllwaysErrorInputStream();

    @Test
    public void shouldCorrectlyDecodeAStream() throws IOException {
        String value = "expected";
        ByteArrayInputStream is = new ByteArrayInputStream("expected".getBytes());
        String decoded = StreamUtils.getStreamContents((InputStream)is);
        Assert.assertEquals((Object)"expected", (Object)decoded);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailForNullParameter() throws IOException {
        StreamUtils.getStreamContents(null);
        Assert.fail((String)"Must throw exception before getting here");
    }

    @Test(expected=IOException.class)
    public void shouldFailWithBrokenStream() throws IOException {
        StreamUtils.getStreamContents((InputStream)ALLWAYS_ERROR_INPUT_STREAM);
        Assert.fail((String)"Must throw exception before getting here");
    }

    private static class AllwaysErrorInputStream
    extends InputStream {
        private AllwaysErrorInputStream() {
        }

        @Override
        public int read() throws IOException {
            throw new IOException();
        }
    }
}

