/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Parameter;
import com.github.scribejava.core.oauth.CompletedFuture;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.concurrent.Future;

class OAuth20ServiceUnit
extends OAuth20Service {
    static final String TOKEN = "ae82980abab675c646a070686d5558ad";
    static final String STATE = "123";
    static final int EXPIRES = 3600;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    OAuth20ServiceUnit(DefaultApi20 api, String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super(api, apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
    }

    protected OAuth2AccessToken sendAccessTokenRequestSync(OAuthRequest request) {
        return new OAuth2AccessToken(TOKEN, this.prepareRawResponse(request));
    }

    private String prepareRawResponse(OAuthRequest request) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("access_token", TOKEN);
        response.put("state", STATE);
        response.put("expires_in", 3600);
        response.putAll(request.getHeaders());
        response.putAll(request.getOauthParameters());
        for (Parameter param : request.getBodyParams().getParams()) {
            response.put("query-" + param.getKey(), param.getValue());
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(response);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException("smth wrong with Jackson?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Future<OAuth2AccessToken> sendAccessTokenRequestAsync(OAuthRequest request, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuth2AccessToken accessToken = new OAuth2AccessToken(TOKEN, this.prepareRawResponse(request));
        try {
            CompletedFuture<OAuth2AccessToken> completedFuture = new CompletedFuture<OAuth2AccessToken>(accessToken);
            return completedFuture;
        }
        finally {
            if (callback != null) {
                callback.onCompleted((Object)accessToken);
            }
        }
    }
}

