/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Parameter;
import com.github.scribejava.core.model.Verb;
import org.junit.Assert;
import org.junit.Test;

public class RequestTest {
    @Test
    public void shouldGetQueryStringParameters() {
        OAuthRequest postRequest = new OAuthRequest(Verb.POST, "http://example.com");
        postRequest.addBodyParameter("param", "value");
        postRequest.addBodyParameter("param with spaces", "value with spaces");
        OAuthRequest getRequest = new OAuthRequest(Verb.GET, "http://example.com?qsparam=value&other+param=value+with+spaces");
        Assert.assertEquals((long)2L, (long)getRequest.getQueryStringParams().size());
        Assert.assertEquals((long)0L, (long)postRequest.getQueryStringParams().size());
        Assert.assertTrue((boolean)getRequest.getQueryStringParams().contains(new Parameter("qsparam", "value")));
    }

    @Test
    public void shouldSetBodyParamsAndAddContentLength() {
        OAuthRequest postRequest = new OAuthRequest(Verb.POST, "http://example.com");
        postRequest.addBodyParameter("param", "value");
        postRequest.addBodyParameter("param with spaces", "value with spaces");
        Assert.assertEquals((Object)"param=value&param%20with%20spaces=value%20with%20spaces", (Object)new String(postRequest.getByteArrayPayload()));
    }

    @Test
    public void shouldSetPayloadAndHeaders() {
        OAuthRequest postRequest = new OAuthRequest(Verb.POST, "http://example.com");
        postRequest.addBodyParameter("param", "value");
        postRequest.addBodyParameter("param with spaces", "value with spaces");
        postRequest.setPayload("PAYLOAD");
        Assert.assertEquals((Object)"PAYLOAD", (Object)postRequest.getStringPayload());
    }

    @Test
    public void shouldAllowAddingQuerystringParametersAfterCreation() {
        OAuthRequest request = new OAuthRequest(Verb.GET, "http://example.com?one=val");
        request.addQuerystringParameter("two", "other val");
        request.addQuerystringParameter("more", "params");
        Assert.assertEquals((long)3L, (long)request.getQueryStringParams().size());
    }

    @Test
    public void shouldReturnTheCompleteUrl() {
        OAuthRequest request = new OAuthRequest(Verb.GET, "http://example.com?one=val");
        request.addQuerystringParameter("two", "other val");
        request.addQuerystringParameter("more", "params");
        Assert.assertEquals((Object)"http://example.com?one=val&two=other%20val&more=params", (Object)request.getCompleteUrl());
    }

    @Test
    public void shouldHandleQueryStringSpaceEncodingProperly() {
        OAuthRequest getRequest = new OAuthRequest(Verb.GET, "http://example.com?qsparam=value&other+param=value+with+spaces");
        Assert.assertTrue((boolean)getRequest.getQueryStringParams().contains(new Parameter("other param", "value with spaces")));
    }

    @Test
    public void shouldNotEncodeInStringPayload() throws Exception {
        String requestBody = "~/!@#$%^&*( )_+//\r\n%2F&amp;";
        OAuthRequest postRequest = new OAuthRequest(Verb.POST, "http://example.com");
        postRequest.setPayload("~/!@#$%^&*( )_+//\r\n%2F&amp;");
        Assert.assertEquals((Object)"~/!@#$%^&*( )_+//\r\n%2F&amp;", (Object)postRequest.getStringPayload());
    }

    @Test
    public void shouldNotEncodeInByteBodyPayload() throws Exception {
        byte[] requestBody = "~/!@#$%^&*( )_+//\r\n%2F&amp;".getBytes();
        OAuthRequest postRequest = new OAuthRequest(Verb.POST, "http://example.com");
        postRequest.setPayload(requestBody);
        Assert.assertArrayEquals((byte[])requestBody, (byte[])postRequest.getByteArrayPayload());
    }

    @Test
    public void shouldEncodeInBodyParamsPayload() throws Exception {
        String expectedRequestBodyParamName = "~/!@#$%^&*( )_+//\r\n%2F&amp;name";
        String expectedRequestBodyParamValue = "~/!@#$%^&*( )_+//\r\n%2F&amp;value";
        String expectedRequestBody = "~%2F%21%40%23%24%25%5E%26%2A%28%20%29_%2B%2F%2F%0D%0A%252F%26amp%3Bname=~%2F%21%40%23%24%25%5E%26%2A%28%20%29_%2B%2F%2F%0D%0A%252F%26amp%3Bvalue";
        OAuthRequest postRequest = new OAuthRequest(Verb.POST, "http://example.com");
        postRequest.addBodyParameter("~/!@#$%^&*( )_+//\r\n%2F&amp;name", "~/!@#$%^&*( )_+//\r\n%2F&amp;value");
        Assert.assertArrayEquals((byte[])"~%2F%21%40%23%24%25%5E%26%2A%28%20%29_%2B%2F%2F%0D%0A%252F%26amp%3Bname=~%2F%21%40%23%24%25%5E%26%2A%28%20%29_%2B%2F%2F%0D%0A%252F%26amp%3Bvalue".getBytes(), (byte[])postRequest.getByteArrayPayload());
    }
}

