/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.model.OAuth1AccessToken;
import org.junit.Assert;
import org.junit.Test;

public class TokenTest {
    @Test
    public void shouldTestEqualityBasedOnTokenAndSecret() {
        OAuth1AccessToken expected = new OAuth1AccessToken("access", "secret");
        OAuth1AccessToken actual = new OAuth1AccessToken("access", "secret");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((Object)actual, (Object)actual);
    }

    @Test
    public void shouldNotDependOnRawString() {
        OAuth1AccessToken expected = new OAuth1AccessToken("access", "secret", "raw_string");
        OAuth1AccessToken actual = new OAuth1AccessToken("access", "secret", "different_raw_string");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldReturnSameHashCodeForEqualObjects() {
        OAuth1AccessToken expected = new OAuth1AccessToken("access", "secret");
        OAuth1AccessToken actual = new OAuth1AccessToken("access", "secret");
        Assert.assertEquals((long)expected.hashCode(), (long)actual.hashCode());
    }

    @Test
    public void shouldNotBeEqualToNullOrOtherObjects() {
        OAuth1AccessToken expected = new OAuth1AccessToken("access", "secret", "response");
        Assert.assertNotSame((Object)expected, null);
        Assert.assertNotSame((Object)expected, (Object)new Object());
    }

    @Test
    public void shouldReturnUrlParam() {
        OAuth1AccessToken actual = new OAuth1AccessToken("acccess", "secret", "user_id=3107154759&screen_name=someuser&empty=&=");
        Assert.assertEquals((Object)"someuser", (Object)actual.getParameter("screen_name"));
        Assert.assertEquals((Object)"3107154759", (Object)actual.getParameter("user_id"));
        Assert.assertEquals(null, (Object)actual.getParameter("empty"));
        Assert.assertEquals(null, (Object)actual.getParameter(null));
    }
}

