/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.core.base64.Base64;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2Authorization;
import com.github.scribejava.core.oauth.OAuth20ApiUnit;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class OAuth20ServiceTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test
    public void shouldProduceCorrectRequestSync() throws IOException, InterruptedException, ExecutionException {
        OAuth20Service service = new ServiceBuilder("your_api_key").apiSecret("your_api_secret").build((DefaultApi20)new OAuth20ApiUnit());
        OAuth2AccessToken token = service.getAccessTokenPasswordGrant("user1", "password1");
        Assert.assertNotNull((Object)token);
        JsonNode response = OBJECT_MAPPER.readTree(token.getRawResponse());
        Assert.assertEquals((Object)"ae82980abab675c646a070686d5558ad", (Object)response.get("access_token").asText());
        Assert.assertEquals((long)3600L, (long)response.get("expires_in").asInt());
        String authorize = Base64.encode((byte[])String.format("%s:%s", service.getApiKey(), service.getApiSecret()).getBytes(Charset.forName("UTF-8")));
        Assert.assertEquals((Object)("Basic " + authorize), (Object)response.get("Authorization").asText());
        Assert.assertEquals((Object)"user1", (Object)response.get("query-username").asText());
        Assert.assertEquals((Object)"password1", (Object)response.get("query-password").asText());
        Assert.assertEquals((Object)"password", (Object)response.get("query-grant_type").asText());
    }

    @Test
    public void shouldProduceCorrectRequestAsync() throws ExecutionException, InterruptedException, IOException {
        OAuth20Service service = new ServiceBuilder("your_api_key").apiSecret("your_api_secret").build((DefaultApi20)new OAuth20ApiUnit());
        OAuth2AccessToken token = (OAuth2AccessToken)service.getAccessTokenPasswordGrantAsync("user1", "password1").get();
        Assert.assertNotNull((Object)token);
        JsonNode response = OBJECT_MAPPER.readTree(token.getRawResponse());
        Assert.assertEquals((Object)"ae82980abab675c646a070686d5558ad", (Object)response.get("access_token").asText());
        Assert.assertEquals((long)3600L, (long)response.get("expires_in").asInt());
        String authorize = Base64.encode((byte[])String.format("%s:%s", service.getApiKey(), service.getApiSecret()).getBytes(Charset.forName("UTF-8")));
        Assert.assertEquals((Object)("Basic " + authorize), (Object)response.get("Authorization").asText());
        Assert.assertEquals((Object)"user1", (Object)response.get("query-username").asText());
        Assert.assertEquals((Object)"password1", (Object)response.get("query-password").asText());
        Assert.assertEquals((Object)"password", (Object)response.get("query-grant_type").asText());
    }

    @Test
    public void testOAuthExtractAuthorization() {
        OAuth20Service service = new ServiceBuilder("your_api_key").apiSecret("your_api_secret").build((DefaultApi20)new OAuth20ApiUnit());
        OAuth2Authorization authorization = service.extractAuthorization("https://cl.ex.com/cb?code=SplxlOB&state=xyz");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals((Object)"xyz", (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?state=xyz&code=SplxlOB");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals((Object)"xyz", (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?key=value&state=xyz&code=SplxlOB");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals((Object)"xyz", (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?state=xyz&code=SplxlOB&key=value&");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals((Object)"xyz", (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?code=SplxlOB&state=");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?code=SplxlOB");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?code=");
        Assert.assertEquals(null, (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?code");
        Assert.assertEquals(null, (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?");
        Assert.assertEquals(null, (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb");
        Assert.assertEquals(null, (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
    }
}

