/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ScopeBuilder {
    private final Set<String> scopes = new HashSet<String>();

    public ScopeBuilder() {
    }

    public ScopeBuilder(String scope) {
        this.withScope(scope);
    }

    public ScopeBuilder(String ... scopes) {
        this.withScopes(scopes);
    }

    public ScopeBuilder(Collection<String> scopes) {
        this.withScopes(scopes);
    }

    public final ScopeBuilder withScope(String scope) {
        this.scopes.add(scope);
        return this;
    }

    public final ScopeBuilder withScopes(String ... scopes) {
        this.scopes.addAll(Arrays.asList(scopes));
        return this;
    }

    public final ScopeBuilder withScopes(Collection<String> scopes) {
        this.scopes.addAll(scopes);
        return this;
    }

    public String build() {
        StringBuilder scopeBuilder = new StringBuilder();
        for (String scope : this.scopes) {
            scopeBuilder.append(' ').append(scope);
        }
        return scopeBuilder.substring(1);
    }
}

