/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.apache;

import com.github.scribejava.core.httpclient.AbstractAsyncOnlyHttpClient;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.httpclient.apache.ApacheHttpClientConfig;
import com.github.scribejava.httpclient.apache.ApacheHttpFuture;
import com.github.scribejava.httpclient.apache.OAuthAsyncCompletionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;

public class ApacheHttpClient
extends AbstractAsyncOnlyHttpClient {
    private final CloseableHttpAsyncClient client;

    public ApacheHttpClient() {
        this(ApacheHttpClientConfig.defaultConfig());
    }

    public ApacheHttpClient(ApacheHttpClientConfig config) {
        this(config.getHttpAsyncClientBuilder());
    }

    public ApacheHttpClient(HttpAsyncClientBuilder builder) {
        this(builder.build());
    }

    public ApacheHttpClient(CloseableHttpAsyncClient client) {
        this.client = client;
        this.client.start();
    }

    public void close() throws IOException {
        this.client.close();
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        ByteArrayEntity entity = bodyContents == null ? null : new ByteArrayEntity(bodyContents);
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, (HttpEntity)entity, callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        StringEntity entity = bodyContents == null ? null : new StringEntity(bodyContents, StandardCharsets.UTF_8);
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, (HttpEntity)entity, callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        FileEntity entity = bodyContents == null ? null : new FileEntity(bodyContents);
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, (HttpEntity)entity, callback, converter);
    }

    private <T> Future<T> doExecuteAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, HttpEntity entity, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        RequestBuilder builder = ApacheHttpClient.getRequestBuilder(httpVerb);
        builder.setUri(completeUrl);
        if (httpVerb.isPermitBody()) {
            if (!headers.containsKey("Content-Type")) {
                builder.addHeader("Content-Type", "application/x-www-form-urlencoded");
            }
            builder.setEntity(entity);
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            builder.addHeader(header.getKey(), header.getValue());
        }
        if (userAgent != null) {
            builder.setHeader("User-Agent", userAgent);
        }
        OAuthAsyncCompletionHandler<T> handler = new OAuthAsyncCompletionHandler<T>(callback, converter);
        Future future = this.client.execute(builder.build(), handler);
        return new ApacheHttpFuture<T>(future, handler);
    }

    private static RequestBuilder getRequestBuilder(Verb httpVerb) {
        switch (httpVerb) {
            case GET: {
                return RequestBuilder.get();
            }
            case PUT: {
                return RequestBuilder.put();
            }
            case DELETE: {
                return RequestBuilder.delete();
            }
            case HEAD: {
                return RequestBuilder.head();
            }
            case POST: {
                return RequestBuilder.post();
            }
            case PATCH: {
                return RequestBuilder.patch();
            }
            case TRACE: {
                return RequestBuilder.trace();
            }
            case OPTIONS: {
                return RequestBuilder.options();
            }
        }
        throw new IllegalArgumentException("message build error: unknown verb type");
    }
}

