/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.armeria;

import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.httpclient.armeria.ArmeriaWebClientBuilder;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.logging.LoggingClient;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.common.SessionProtocol;
import java.util.function.Function;

public class ArmeriaHttpClientConfig
implements HttpClientConfig {
    private static final SessionProtocol DEFAULT_PROTOCOL_PREFERENCE = SessionProtocol.H1;
    private final ClientOptions clientOptions;
    private final ClientFactory clientFactory;
    private SessionProtocol protocolPreference;
    private Function<? super HttpClient, RetryingClient> retry;
    private Function<? super HttpClient, LoggingClient> logging;

    public ArmeriaHttpClientConfig(ClientOptions clientOptions, ClientFactory clientFactory) {
        this.clientOptions = clientOptions;
        this.clientFactory = clientFactory;
        this.protocolPreference = DEFAULT_PROTOCOL_PREFERENCE;
    }

    public HttpClientConfig createDefaultConfig() {
        return ArmeriaHttpClientConfig.defaultConfig();
    }

    public static ArmeriaHttpClientConfig defaultConfig() {
        return new ArmeriaHttpClientConfig(null, null);
    }

    public void setProtocolPreference(SessionProtocol protocolPreference) {
        if (protocolPreference != SessionProtocol.H1 && protocolPreference != SessionProtocol.H2) {
            throw new IllegalArgumentException("Invalid protocolPreference: " + protocolPreference);
        }
        this.protocolPreference = protocolPreference;
    }

    public void setRetry(Function<? super HttpClient, RetryingClient> retry) {
        this.retry = retry;
    }

    public void setLogging(Function<? super HttpClient, LoggingClient> logging) {
        this.logging = logging;
    }

    ArmeriaWebClientBuilder createClientBuilder() {
        return new ArmeriaWebClientBuilder(this.clientOptions, this.clientFactory, this.protocolPreference, this.retry, this.logging);
    }
}

