/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.armeria;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientBuilder;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.logging.LoggingClient;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.common.SessionProtocol;
import java.util.function.Function;

public class ArmeriaWebClientBuilder {
    private final ClientFactory clientFactory;
    private final ClientOptions clientOptions;
    private final SessionProtocol protocolPreference;
    private final Function<? super HttpClient, RetryingClient> retry;
    private final Function<? super HttpClient, LoggingClient> logging;

    ArmeriaWebClientBuilder(ClientOptions clientOptions, ClientFactory clientFactory, SessionProtocol protocolPreference, Function<? super HttpClient, RetryingClient> retry, Function<? super HttpClient, LoggingClient> logging) {
        this.clientOptions = clientOptions;
        this.clientFactory = clientFactory;
        this.protocolPreference = protocolPreference;
        this.retry = retry;
        this.logging = logging;
    }

    WebClient newWebClient(String scheme, String authority) {
        SessionProtocol protocol = this.protocol(scheme);
        Endpoint endpoint = Endpoint.parse((String)authority);
        WebClientBuilder clientBuilder = WebClient.builder((SessionProtocol)protocol, (EndpointGroup)endpoint);
        if (this.clientOptions != null) {
            clientBuilder.options(this.clientOptions);
        }
        if (this.clientFactory != null) {
            clientBuilder.factory(this.clientFactory);
        }
        if (this.retry != null) {
            clientBuilder.decorator(this.retry);
        }
        if (this.logging != null) {
            clientBuilder.decorator(this.logging);
        }
        return clientBuilder.build();
    }

    private SessionProtocol protocol(String scheme) {
        SessionProtocol protocol = SessionProtocol.of((String)scheme);
        switch (protocol) {
            case HTTP: {
                if (this.protocolPreference != SessionProtocol.H1) break;
                return SessionProtocol.H1C;
            }
            case HTTPS: {
                if (this.protocolPreference != SessionProtocol.H1) break;
                return SessionProtocol.H1;
            }
        }
        return protocol;
    }
}

