/*
 * Decompiled with CFR 0.152.
 */
package com.github.thstock.djp;

import com.github.thstock.djp.util.HashEquals;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DockerfileLine
extends HashEquals {
    final String token;
    final String value;
    private static Pattern p = Pattern.compile("(^[^ \t]+[ \t]+)(.+)");

    public static DockerfileLine from(String line) {
        Matcher matcher = p.matcher(line);
        if (!matcher.find()) {
            throw new IllegalStateException("Invalid Dockerfileline: '" + line + "'");
        }
        String token = matcher.group(1);
        String value = line.substring(token.length());
        return new DockerfileLine(token.trim(), value);
    }

    DockerfileLine(String token, String value) {
        this.token = token;
        this.value = value;
    }

    String getToken() {
        return this.token;
    }

    String getValue() {
        return this.value;
    }

    public boolean isToken(String token) {
        return this.token.equals(token);
    }

    public ImmutableList<String> valueTokens() {
        ArrayList objects = Lists.newArrayList();
        String token = "";
        boolean quoteOpen = false;
        boolean newline = false;
        for (char c : this.getValue().toCharArray()) {
            if (c == '\"' || c == '\'') {
                boolean bl = quoteOpen = !quoteOpen;
                if (!quoteOpen) {
                    if (newline) {
                        newline = false;
                    }
                    this.applyNonEmpty(objects, token);
                    token = "";
                }
            }
            if (!quoteOpen) {
                if (c == '=') {
                    this.applyNonEmpty(objects, token);
                    objects.add("=");
                    token = "";
                    continue;
                }
                if (c == '\n' || c == ' ' || c == '\t') {
                    newline = true;
                    this.applyNonEmpty(objects, token.trim());
                    if (!((String)Iterables.getLast((Iterable)objects)).equals(" ")) {
                        objects.add(" ");
                    }
                    token = "";
                    continue;
                }
                if (c == '\"' || c == '\'') continue;
                token = token + c;
                continue;
            }
            if (c == '\"' || c == '\'') continue;
            token = token + c;
        }
        if (token.length() > 0) {
            if (newline) {
                objects.add(token.replaceFirst("^[ \t]+", ""));
            } else {
                objects.add(token);
            }
        }
        return ImmutableList.copyOf((Collection)objects);
    }

    private void applyNonEmpty(ArrayList<String> objects, String token) {
        if (token.trim().length() > 0) {
            objects.add(token);
        }
    }
}

