/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.commandlineUserPromptProcessor.parsables;

import com.github.vatbub.commandlineUserPromptProcessor.parsables.Parsable;
import com.github.vatbub.commandlineUserPromptProcessor.parsables.ParseException;
import org.jetbrains.annotations.Nullable;

public class ParsableInteger
implements Parsable<Integer> {
    private int minValue;
    private int maxValue;
    private int value;
    @Nullable
    private Integer defaultValue;

    public ParsableInteger() {
        this(null);
    }

    public ParsableInteger(Integer defaultValue) {
        this(defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public ParsableInteger(Integer defaultValue, int minValue, int maxValue) {
        this.setDefaultValue(defaultValue);
        this.setAcceptedValues(minValue, maxValue);
    }

    public void setAcceptedValues(int minValue, int maxValue) {
        if (maxValue < minValue) {
            throw new IllegalArgumentException("maxValue must be bigger than or equal to minValue");
        }
        this.maxValue = maxValue;
        this.minValue = minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    @Override
    public void fromString(String s) throws ParseException {
        try {
            this.value = Integer.parseInt(s);
            if (this.value < this.minValue || this.value > this.maxValue) {
                throw new IndexOutOfBoundsException();
            }
        }
        catch (NumberFormatException e) {
            if (this.defaultValue != null) {
                this.value = this.defaultValue;
            }
            throw new ParseException();
        }
    }

    @Override
    @Nullable
    public String getOptionsString() {
        if (this.minValue == Integer.MIN_VALUE && this.maxValue == Integer.MAX_VALUE) {
            return null;
        }
        if (this.minValue != Integer.MIN_VALUE && this.maxValue != Integer.MAX_VALUE) {
            return this.minValue + " <= x <= " + this.maxValue;
        }
        if (this.minValue != Integer.MIN_VALUE) {
            return this.minValue + " <= x";
        }
        return "x <= " + this.maxValue;
    }

    @Override
    @Nullable
    public String getStringForDefaultValue() {
        if (this.defaultValue == null) {
            return null;
        }
        return this.defaultValue.toString();
    }

    @Override
    @Nullable
    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(@Nullable Integer defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Integer toValue() {
        return this.value;
    }
}

