/*
 * Decompiled with CFR 0.152.
 */
package Core.BasicDataType;

import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class RandomHelper {
    public static final String NUMBERS_AND_LETTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMBERS = "0123456789";
    public static final String LETTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String CAPITAL_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LOWER_CASE_LETTERS = "abcdefghijklmnopqrstuvwxyz";

    private RandomHelper() {
        throw new AssertionError();
    }

    public static String getRandomNumbersAndLetters(int length) {
        return RandomHelper.getRandom(NUMBERS_AND_LETTERS, length);
    }

    public static String getRandomNumbers(int length) {
        return RandomHelper.getRandom(NUMBERS, length);
    }

    public static String getRandomLetters(int length) {
        return RandomHelper.getRandom(LETTERS, length);
    }

    public static String getRandomCapitalLetters(int length) {
        return RandomHelper.getRandom(CAPITAL_LETTERS, length);
    }

    public static String getRandomLowerCaseLetters(int length) {
        return RandomHelper.getRandom(LOWER_CASE_LETTERS, length);
    }

    public static String getRandom(String source, int length) {
        return StringUtils.isEmpty((CharSequence)source) ? null : RandomHelper.getRandom(source.toCharArray(), length);
    }

    public static String getRandom(char[] sourceChar, int length) {
        if (sourceChar == null || sourceChar.length == 0 || length < 0) {
            return null;
        }
        StringBuilder str = new StringBuilder(length);
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            str.append(sourceChar[random.nextInt(sourceChar.length)]);
        }
        return str.toString();
    }

    public static int getRandom(int max) {
        return RandomHelper.getRandom(0, max);
    }

    public static int getRandom(int min, int max) {
        if (min > max) {
            return 0;
        }
        if (min == max) {
            return min;
        }
        return min + new Random().nextInt(max - min);
    }

    public static boolean shuffle(Object[] objArray) {
        if (objArray == null) {
            return false;
        }
        return RandomHelper.shuffle(objArray, RandomHelper.getRandom(objArray.length));
    }

    public static boolean shuffle(Object[] objArray, int shuffleCount) {
        int length;
        if (objArray == null || shuffleCount < 0 || (length = objArray.length) < shuffleCount) {
            return false;
        }
        for (int i = 1; i <= shuffleCount; ++i) {
            int random = RandomHelper.getRandom(length - i);
            Object temp = objArray[length - i];
            objArray[length - i] = objArray[random];
            objArray[random] = temp;
        }
        return true;
    }

    public static int[] shuffle(int[] intArray) {
        if (intArray == null) {
            return null;
        }
        return RandomHelper.shuffle(intArray, RandomHelper.getRandom(intArray.length));
    }

    public static int[] shuffle(int[] intArray, int shuffleCount) {
        int length;
        if (intArray == null || shuffleCount < 0 || (length = intArray.length) < shuffleCount) {
            return null;
        }
        int[] out = new int[shuffleCount];
        for (int i = 1; i <= shuffleCount; ++i) {
            int random = RandomHelper.getRandom(length - i);
            out[i - 1] = intArray[random];
            int temp = intArray[length - i];
            intArray[length - i] = intArray[random];
            intArray[random] = temp;
        }
        return out;
    }
}

