/*
 * Decompiled with CFR 0.152.
 */
package Core.IO;

import Core.Entity.FileMetaEntity;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class FileHelper {
    private static Logger log = Logger.getLogger(FileHelper.class);

    public static boolean CreateDirectory(String destDirName) {
        File dir;
        if (!destDirName.endsWith(File.separator)) {
            destDirName = destDirName + File.separator;
        }
        if ((dir = new File(destDirName)).exists()) {
            return false;
        }
        return dir.mkdirs();
    }

    public static List<FileMetaEntity> ReadFileOrFolderMetaInfo(String filepath) throws IOException {
        ArrayList<FileMetaEntity> ReturnList = new ArrayList<FileMetaEntity>();
        try {
            File file = new File(filepath);
            BasicFileAttributes ra = Files.readAttributes(Paths.get(filepath, new String[0]), BasicFileAttributes.class, new LinkOption[0]);
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            FileTime ftCreateTime = ra.creationTime();
            Date CreateTime = new Date(df.format(ftCreateTime.toMillis()));
            FileTime ftModifyTime = ra.lastModifiedTime();
            Date ModifyTime = new Date(df.format(ftModifyTime.toMillis()));
            if (!file.isDirectory()) {
                FileMetaEntity fileMetaEntity = new FileMetaEntity();
                fileMetaEntity.setFileName(file.getName());
                fileMetaEntity.setFilePath(file.getPath());
                fileMetaEntity.setIsFile(true);
                fileMetaEntity.setCreateTime(CreateTime);
                fileMetaEntity.setModifyTime(ModifyTime);
                fileMetaEntity.setFileSize(ra.size());
                ReturnList.add(fileMetaEntity);
            } else if (file.isDirectory()) {
                FileMetaEntity FolderEntity = new FileMetaEntity();
                FolderEntity.setFileName(file.getName());
                FolderEntity.setFilePath(file.getPath());
                FolderEntity.setIsFile(false);
                FolderEntity.setCreateTime(CreateTime);
                FolderEntity.setModifyTime(ModifyTime);
                FolderEntity.setFileSize(0L);
                ReturnList.add(FolderEntity);
                String[] SubFileList = file.list();
                for (int i = 0; i < SubFileList.length; ++i) {
                    String SubFilePath = filepath + File.separator + SubFileList[i];
                    ReturnList.addAll(FileHelper.ReadFileOrFolderMetaInfo(SubFilePath));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return ReturnList;
    }
}

