/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.executeafm.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.executeafm.response.ResultDimension;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="executionResponse")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExecutionResponse {
    private static final String EXECUTION_RESULT_LINK = "executionResult";
    private final List<ResultDimension> dimensions;
    private final Map<String, String> links;

    public ExecutionResponse(List<ResultDimension> dimensions, String executionResultUri) {
        this(dimensions, new LinkedHashMap<String, String>());
        this.links.put(EXECUTION_RESULT_LINK, (String)Validate.notEmpty((CharSequence)executionResultUri, (String)"executionResultUri"));
    }

    @JsonCreator
    private ExecutionResponse(@JsonProperty(value="dimensions") List<ResultDimension> dimensions, @JsonProperty(value="links") Map<String, String> links) {
        this.dimensions = (List)Validate.notNull(dimensions, (String)"dimensions");
        this.links = (Map)Validate.notNull(links, (String)"links");
    }

    public List<ResultDimension> getDimensions() {
        return this.dimensions;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonIgnore
    public String getExecutionResultUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(EXECUTION_RESULT_LINK);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

